/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.db;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.internal.ConfigUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public class SqlStatementUnsanitizedExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final SqlClientAttributesGetter<REQUEST> getter;
    final boolean isSqlRaw;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlStatementUnsanitizedExtractor<REQUEST, RESPONSE>(getter);
    }

    SqlStatementUnsanitizedExtractor(SqlClientAttributesGetter<REQUEST> getter) {
        this.getter = getter;
        this.isSqlRaw = Boolean.parseBoolean(ConfigUtil.getString("otel.instrumentation.jdbc.statement-sanitizer.enabled", "true"));
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String sqlRaw = this.getter.getRawQueryText(request);
        this.addStatementUnsanitized(attributes, sqlRaw);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }

    private void addStatementUnsanitized(AttributesBuilder attributes, String sqlRaw) {
        if (!this.isSqlRaw) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_STATEMENT_UNSANITIZED, sqlRaw);
        }
    }
}

