/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.common.SecurityCheckSwitch;
import javax.annotation.Nullable;

public final class SqlClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final SqlClientAttributesGetter<REQUEST> getter;
    private static final int SQL_MAX_LENGTH = 256;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    SqlClientPeerServiceAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context context, REQUEST request) {
        String sqlRaw = this.getter.getRawQueryText(request);
        if (sqlRaw == null || sqlRaw.trim().isEmpty() || sqlRaw.length() > 256) {
            return;
        }
        if (SecurityCheckSwitch.isClosedSqlInjectionSwitch()) {
            return;
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

