/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.db;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.NetworkAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.network.ServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.net.InetSocketAddress;
import javax.annotation.Nullable;

public final class DbJedisClientAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final AttributesExtractor<REQUEST, RESPONSE> delegate;
    private static final String PEER_SERVICE_PREFIX_KEY = "redis://";

    private DbJedisClientAttributesExtractor(AttributesExtractor<REQUEST, RESPONSE> delegate) {
        this.delegate = delegate;
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> createServer(DbClientCommonAttributesGetter<REQUEST> getter, ServerAttributesGetter<REQUEST> serverAttributesGetter) {
        return new DbJedisClientAttributesExtractor(new Server(getter, serverAttributesGetter));
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> createNetwork(DbClientCommonAttributesGetter<REQUEST> getter, NetworkAttributesGetter<REQUEST, RESPONSE> networkAttributesGetter) {
        return new DbJedisClientAttributesExtractor<REQUEST, RESPONSE>(new Network<REQUEST, RESPONSE>(getter, networkAttributesGetter));
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        this.delegate.onStart(attributes, parentContext, request);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        this.delegate.onEnd(attributes, context, request, response, error);
    }

    static final class Server<REQUEST, RESPONSE>
    implements AttributesExtractor<REQUEST, RESPONSE> {
        final ServerAttributesGetter<REQUEST> serverAttributesGetter;
        final DbClientCommonAttributesGetter<REQUEST> getter;

        Server(DbClientCommonAttributesGetter<REQUEST> getter, ServerAttributesGetter<REQUEST> serverAttributesGetter) {
            this.getter = getter;
            this.serverAttributesGetter = serverAttributesGetter;
        }

        @Override
        public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
            String dbHost = this.serverAttributesGetter.getServerAddress(request);
            Integer serverPort = this.serverAttributesGetter.getServerPort(request);
            String peerService = dbHost + ":" + serverPort;
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.PEER_SERVICE, DbJedisClientAttributesExtractor.PEER_SERVICE_PREFIX_KEY + peerService);
        }

        @Override
        public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        }
    }

    static final class Network<REQUEST, RESPONSE>
    implements AttributesExtractor<REQUEST, RESPONSE> {
        final NetworkAttributesGetter<REQUEST, RESPONSE> networkAttributesGetter;
        final DbClientCommonAttributesGetter<REQUEST> getter;

        Network(DbClientCommonAttributesGetter<REQUEST> getter, NetworkAttributesGetter<REQUEST, RESPONSE> networkAttributesGetter) {
            this.getter = getter;
            this.networkAttributesGetter = networkAttributesGetter;
        }

        @Override
        public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        }

        @Override
        public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
            InetSocketAddress peerInetSocketAddress = this.networkAttributesGetter.getNetworkPeerInetSocketAddress(request, response);
            if (peerInetSocketAddress != null) {
                String peerService = peerInetSocketAddress.getHostName() + ":" + peerInetSocketAddress.getPort();
                AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.PEER_SERVICE, DbJedisClientAttributesExtractor.PEER_SERVICE_PREFIX_KEY + peerService);
            }
        }
    }
}

