/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.db;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public final class DbClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final DbClientCommonAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(DbClientCommonAttributesGetter<REQUEST> getter) {
        return new DbClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    DbClientPeerServiceAttributesExtractor(DbClientCommonAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String dbHost = this.getter.getConnectionString(request);
        String name = this.getter.getDbNamespace(request);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DB_NAMESPACE, name);
        AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.PEER_SERVICE, dbHost);
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

