/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.event.api;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.logging.Level;

public class JvmMonitorMethodTraceRecorderWrapper {
    private static final PatchLogger logger = PatchLogger.getLogger(JvmMonitorMethodTraceRecorderWrapper.class.getName());
    private static final String METHOD_TRACE_RECORDER_CLASS = "io.opentelemetry.tencent.javaagent.shaded.instrumentation.event.api.JvmMonitorMethodTraceRecorder";
    private static Class<?> recorderClass;

    public static void onMethodEnter(String className, String methodSig, String loaderSig) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onMethodEnter", String.class, String.class, String.class);
            m.invoke(null, className, methodSig, loaderSig);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onMethodEnter- " + e.getMessage());
        }
    }

    public static void onMethodExit(String className, String methodSig, String loaderSig, boolean returnNormally) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onMethodExit", String.class, String.class, String.class, Boolean.TYPE);
            m.invoke(null, className, methodSig, loaderSig, returnNormally);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onMethodExit- " + e.getMessage());
        }
    }

    public static void beforeMethodCall(String owner, String name, String descriptor, int line) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("beforeMethodCall", String.class, String.class, String.class, Integer.TYPE);
            m.invoke(null, owner, name, descriptor, line);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper beforeMethodCall- " + e.getMessage());
        }
    }

    public static void afterMethodCall(String owner, String name, String descriptor, int line) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("afterMethodCall", String.class, String.class, String.class, Integer.TYPE);
            m.invoke(null, owner, name, descriptor, line);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper afterMethodCall- " + e.getMessage());
        }
    }

    public static void onArgumentPushBool(int idx, boolean arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushBool", Integer.TYPE, Boolean.TYPE, Boolean.TYPE);
            m.invoke(null, idx, arg, isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushBool- " + e.getMessage());
        }
    }

    public static void onArgumentPushChar(int idx, char arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushChar", Integer.TYPE, Character.TYPE, Boolean.TYPE);
            m.invoke(null, idx, Character.valueOf(arg), isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushChar- " + e.getMessage());
        }
    }

    public static void onArgumentPushByte(int idx, byte arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushByte", Integer.TYPE, Byte.TYPE, Boolean.TYPE);
            m.invoke(null, idx, arg, isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushByte- " + e.getMessage());
        }
    }

    public static void onArgumentPushShort(int idx, short arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushShort", Integer.TYPE, Short.TYPE, Boolean.TYPE);
            m.invoke(null, idx, arg, isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushShort- " + e.getMessage());
        }
    }

    public static void onArgumentPushInt(int idx, int arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushInt", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            m.invoke(null, idx, arg, isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushInt- " + e.getMessage());
        }
    }

    public static void onArgumentPushFloat(int idx, float arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushFloat", Integer.TYPE, Float.TYPE, Boolean.TYPE);
            m.invoke(null, idx, Float.valueOf(arg), isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushFloat- " + e.getMessage());
        }
    }

    public static void onArgumentPushDouble(int idx, double arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushDouble", Integer.TYPE, Double.TYPE, Boolean.TYPE);
            m.invoke(null, idx, arg, isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushDouble- " + e.getMessage());
        }
    }

    public static void onArgumentPushLong(int idx, long arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushLong", Integer.TYPE, Long.TYPE, Boolean.TYPE);
            m.invoke(null, idx, arg, isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushLong- " + e.getMessage());
        }
    }

    public static void onArgumentPushObject(int idx, Object arg, boolean isArgument) {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentPushObject", Integer.TYPE, Object.class, Boolean.TYPE);
            m.invoke(null, idx, arg, isArgument);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentPushObject- " + e.getMessage());
        }
    }

    public static void onArgumentsPushFinishAll() {
        if (recorderClass == null) {
            return;
        }
        try {
            Method m = recorderClass.getMethod("onArgumentsPushFinishAll", new Class[0]);
            m.invoke(null, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
            logger.log(Level.SEVERE, "JvmMonitorMethodTraceRecorderWrapper onArgumentsPushFinishAll- " + e.getMessage());
        }
    }

    static {
        try {
            recorderClass = Class.forName(METHOD_TRACE_RECORDER_CLASS, true, JvmMonitorMethodTraceRecorderWrapper.class.getClassLoader());
        }
        catch (ClassNotFoundException e) {
            logger.log(Level.SEVERE, "Can not successfully load class: io.opentelemetry.tencent.instrumentation.event.api.JvmMonitorMethodTraceRecorder, class loader: " + JvmMonitorMethodTraceRecorderWrapper.class.getClassLoader(), e);
        }
    }
}

