/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.common;

import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.detectengineapi.DetectEngineGetter;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.List;

public class TransContext {
    private static final String MAX_STACK_DEPTH = "MAX_STACK_DEPTH";
    public static final ContextKey<StackTraceElement[]> STACK_TRACE_KEY = ContextKey.named("stack-trace");
    private static final int DEFAULT_DEPTH_LIMIT = 20;

    private TransContext() {
    }

    public static Object getInvoke(Object owner, String methodName, boolean throwException, Class<?>[] types, Object ... args) throws Throwable {
        try {
            Method method = owner.getClass().getMethod(methodName, types);
            if (!method.isAccessible()) {
                method.setAccessible(true);
            }
            return method.invoke(owner, args);
        }
        catch (Throwable t) {
            if (throwException) {
                throw t;
            }
            return null;
        }
    }

    public static Field getOwner(Class<?> clazz, String fieldName) {
        Field field;
        block2: {
            field = null;
            try {
                field = clazz.getDeclaredField(fieldName);
                field.setAccessible(true);
            }
            catch (NoSuchFieldException e) {
                if (clazz.getSuperclass() == null) break block2;
                field = TransContext.getOwner(clazz.getSuperclass(), fieldName);
            }
        }
        return field;
    }

    public static Object getField(Object obj, String fieldName) throws Exception {
        Field field = TransContext.getOwner(obj.getClass(), fieldName);
        return field.get(obj);
    }

    public static StackTraceElement[] limitStackTraceDepth() {
        List<String> depthConfig;
        int maxDepth = 20;
        if (DetectEngineGetter.getInstance() != null && (depthConfig = DetectEngineGetter.getInstance().getStackTraceLength(MAX_STACK_DEPTH)) != null && !depthConfig.isEmpty()) {
            try {
                maxDepth = Integer.parseInt(depthConfig.get(0));
                if (maxDepth <= 0) {
                    maxDepth = 20;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return TransContext.getStackTrace(maxDepth);
    }

    private static StackTraceElement[] getStackTrace(int maxDepth) {
        if (maxDepth <= 0) {
            return new StackTraceElement[0];
        }
        int startIndex = 2;
        Exception e = new Exception();
        StackTraceElement[] fullStack = e.getStackTrace();
        if (startIndex >= fullStack.length) {
            return new StackTraceElement[0];
        }
        int endIndex = Math.min(startIndex + maxDepth, fullStack.length);
        return Arrays.copyOfRange(fullStack, startIndex, endIndex);
    }
}

