/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.common;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.GlobalProfilerConfigProvider;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.detectengineapi.DetectEngineGetter;

public class SecurityCheckSwitch {
    public static final String ATTACK_TYPE_SWITCH = "ATTACK_TYPE_SWITCH";
    public static final String DETECT_TYPE_SWITCH = "DETECT_TYPE_SWITCH";
    public static final String DEPENDENCY_SWITCH = "DEPENDENCY_SWITCH";

    private SecurityCheckSwitch() {
    }

    public static boolean isClosedSqlInjectionSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("4", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isSqlInjectionAnalysis();
    }

    public static boolean isClosedRemoteCommandExecutionSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("3", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isRemoteCommandExecutionAnalysis();
    }

    public static boolean isClosedMemoryHijackingSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("37", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isMemoryHijackingAnalysis();
    }

    public static boolean isClosedJndiInjectionSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("41", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isJNDIInjectionAnalysis();
    }

    public static boolean isClosedJniInjectionSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("42", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isJNIInjectionAnalysis();
    }

    public static boolean isClosedTemplateEngineInjectionSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("38", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isTemplateEngineInjectionAnalysis();
    }

    public static boolean isClosedScriptEngineInjectionSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("39", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isScriptEngineInjectionAnalysis();
    }

    public static boolean isClosedExpressionInjectionSwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact("40", ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isExpressionInjectionAnalysis();
    }

    public static boolean isClosedDependencySwitch() {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact(DEPENDENCY_SWITCH, ATTACK_TYPE_SWITCH) || !GlobalProfilerConfigProvider.get().isAgentEnable() || !GlobalProfilerConfigProvider.get().isInstrumentationVulnerabilityScan();
    }

    public static boolean isClosedDetectTypeSwitch(String detectType) {
        return DetectEngineGetter.getInstance() != null && DetectEngineGetter.getInstance().checkStringExact(detectType, DETECT_TYPE_SWITCH);
    }
}

