/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.checkcacheapi;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public class SecurityCheckParam {
    private String subType;
    private String httpRoute;
    private String payload;
    private final Map<String, String> parameter = new HashMap<String, String>();

    public String getSubType() {
        return this.subType;
    }

    public void setSubType(String subType) {
        this.subType = subType;
    }

    public String getHttpRoute() {
        return this.httpRoute;
    }

    public void setHttpRoute(String httpRoute) {
        this.httpRoute = httpRoute;
    }

    public String getPayload() {
        return this.payload;
    }

    public void setPayload(String payload) {
        this.payload = payload;
    }

    public void setParameter(String key, String value) {
        if (key != null) {
            this.parameter.put(key, value);
        }
    }

    public String getParameter(String key) {
        return this.parameter.get(key);
    }

    public Map<String, String> getAllParameters() {
        return new HashMap<String, String>(this.parameter);
    }

    public String generateCacheKey() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.subType != null ? this.subType : "null").append("|").append(this.httpRoute != null ? this.httpRoute : "null").append("|").append(this.payload != null ? this.payload : "null").append("|");
        this.parameter.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> sb.append((String)entry.getKey()).append("=").append(entry.getValue() != null ? (String)entry.getValue() : "null").append(";"));
        return sb.toString();
    }

    @Deprecated
    public String generateHashCacheKey() {
        return String.valueOf(Objects.hash(this.subType, this.httpRoute, this.payload, this.parameter));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof SecurityCheckParam)) {
            return false;
        }
        SecurityCheckParam that = (SecurityCheckParam)o;
        return Objects.equals(this.subType, that.subType) && Objects.equals(this.httpRoute, that.httpRoute) && Objects.equals(this.payload, that.payload) && Objects.equals(this.parameter, that.parameter);
    }

    public int hashCode() {
        return Objects.hash(this.subType, this.httpRoute, this.payload, this.parameter);
    }

    public String toString() {
        return "SecurityCheckParam{subType='" + this.subType + '\'' + ", httpRoute='" + this.httpRoute + '\'' + ", payload='" + (this.payload != null ? this.payload.substring(0, Math.min(this.payload.length(), 50)) + "..." : "null") + '\'' + ", parameterCount=" + this.parameter.size() + '}';
    }
}

