/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.io.opentelemetry.context;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextStorage;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Scope;
import java.util.logging.Level;
import javax.annotation.Nullable;

enum ThreadLocalContextStorage implements ContextStorage
{
    INSTANCE;

    private static final PatchLogger logger;
    private static final ThreadLocal<Context> THREAD_LOCAL_STORAGE;

    @Override
    public Scope attach(Context toAttach) {
        if (toAttach == null) {
            return NoopScope.INSTANCE;
        }
        Context beforeAttach = this.current();
        if (toAttach == beforeAttach) {
            return NoopScope.INSTANCE;
        }
        THREAD_LOCAL_STORAGE.set(toAttach);
        return new ScopeImpl(beforeAttach, toAttach);
    }

    @Override
    @Nullable
    public Context current() {
        return THREAD_LOCAL_STORAGE.get();
    }

    static {
        logger = PatchLogger.getLogger(ThreadLocalContextStorage.class.getName());
        THREAD_LOCAL_STORAGE = new ThreadLocal();
    }

    static enum NoopScope implements Scope
    {
        INSTANCE;


        @Override
        public void close() {
        }
    }

    private class ScopeImpl
    implements Scope {
        @Nullable
        private final Context beforeAttach;
        private final Context toAttach;
        private boolean closed;
        private final boolean isTsfAgent;

        private ScopeImpl(Context beforeAttach, Context toAttach) {
            this.beforeAttach = beforeAttach;
            this.toAttach = toAttach;
            String tsfApmAgent = System.getenv("OTEL_TSF_APM_AGENT");
            this.isTsfAgent = Boolean.parseBoolean(tsfApmAgent);
        }

        @Override
        public void close() {
            if (this.isTsfAgent) {
                THREAD_LOCAL_STORAGE.set(this.beforeAttach);
                return;
            }
            if (!this.closed && ThreadLocalContextStorage.this.current() == this.toAttach) {
                this.closed = true;
                THREAD_LOCAL_STORAGE.set(this.beforeAttach);
            } else {
                logger.log(Level.FINE, " Trying to close scope which does not represent current context. Ignoring the call.");
            }
        }
    }
}

