/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.internal;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ConfigPropertiesUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.GlobalOpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.HashSet;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;

public final class SupportabilityMetrics {
    private static final PatchLogger logger = PatchLogger.getLogger(SupportabilityMetrics.class.getName());
    private final boolean agentDebugEnabled;
    private final Consumer<String> reporter;
    private final ConcurrentMap<String, KindCounters> suppressionCounters = new ConcurrentHashMap<String, KindCounters>();
    private final ConcurrentMap<String, AtomicLong> counters = new ConcurrentHashMap<String, AtomicLong>();
    private static final SupportabilityMetrics INSTANCE = new SupportabilityMetrics(ConfigPropertiesUtil.getBoolean("otel.javaagent.debug", false), logger::fine).start();
    private static final HashSet<String> unSupportComponentSet = new HashSet();
    private final LongCounter longCounter = GlobalOpenTelemetry.getMeterProvider().meterBuilder("apm.instrumentation.SupportabilityMetrics").build().counterBuilder("suppressed.count").setUnit("1").setDescription("the count of instrumentation suppressed").build();

    public static SupportabilityMetrics instance() {
        return INSTANCE;
    }

    SupportabilityMetrics(boolean agentDebugEnabled, Consumer<String> reporter) {
        this.agentDebugEnabled = agentDebugEnabled;
        this.reporter = reporter;
    }

    public void recordSuppressedSpan(SpanKind kind, String instrumentationName) {
        this.reporterApmMetricMonitor(kind, instrumentationName);
        if (!this.agentDebugEnabled) {
            return;
        }
        this.suppressionCounters.computeIfAbsent(instrumentationName, s -> new KindCounters()).increment(kind);
    }

    private void reporterApmMetricMonitor(SpanKind kind, String instrumentationName) {
        String key = kind.name() + ":" + instrumentationName;
        if (!unSupportComponentSet.contains(key)) {
            Attributes attrs = Attributes.builder().put("kind", kind.name()).put("instrumentation", instrumentationName).build();
            this.longCounter.add(1L, attrs);
            unSupportComponentSet.add(key);
        }
    }

    public void incrementCounter(String counterName) {
        if (!this.agentDebugEnabled) {
            return;
        }
        this.counters.computeIfAbsent(counterName, k -> new AtomicLong()).incrementAndGet();
    }

    void report() {
        this.suppressionCounters.forEach((instrumentationName, countsByKind) -> {
            for (SpanKind kind : SpanKind.values()) {
                long value = countsByKind.getAndReset(kind);
                if (value <= 0L) continue;
                this.reporter.accept("Suppressed Spans by '" + instrumentationName + "' (" + (Object)((Object)kind) + ") : " + value);
            }
        });
        this.counters.forEach((counterName, counter) -> {
            long value = counter.getAndSet(0L);
            if (value > 0L) {
                this.reporter.accept("Counter '" + counterName + "' : " + value);
            }
        });
    }

    private SupportabilityMetrics start() {
        if (this.agentDebugEnabled) {
            ScheduledExecutorService executor = Executors.newScheduledThreadPool(1, runnable -> SupportabilityMetrics.doPrivileged(() -> {
                Thread result = new Thread(runnable, "supportability_metrics_reporter");
                result.setDaemon(true);
                result.setContextClassLoader(null);
                return result;
            }));
            executor.scheduleAtFixedRate(this::report, 5L, 5L, TimeUnit.SECONDS);
            if (executor.isTerminated()) {
                throw new AssertionError();
            }
        }
        return this;
    }

    private static <T> T doPrivileged(PrivilegedAction<T> action) {
        if (System.getSecurityManager() == null) {
            return action.run();
        }
        return AccessController.doPrivileged(action);
    }

    private static class KindCounters {
        private final AtomicLong server = new AtomicLong();
        private final AtomicLong client = new AtomicLong();
        private final AtomicLong internal = new AtomicLong();
        private final AtomicLong consumer = new AtomicLong();
        private final AtomicLong producer = new AtomicLong();

        private KindCounters() {
        }

        void increment(SpanKind kind) {
            switch (kind) {
                case INTERNAL: {
                    this.internal.incrementAndGet();
                    break;
                }
                case SERVER: {
                    this.server.incrementAndGet();
                    break;
                }
                case CLIENT: {
                    this.client.incrementAndGet();
                    break;
                }
                case PRODUCER: {
                    this.producer.incrementAndGet();
                    break;
                }
                case CONSUMER: {
                    this.consumer.incrementAndGet();
                }
            }
        }

        long getAndReset(SpanKind kind) {
            switch (kind) {
                case INTERNAL: {
                    return this.internal.getAndSet(0L);
                }
                case SERVER: {
                    return this.server.getAndSet(0L);
                }
                case CLIENT: {
                    return this.client.getAndSet(0L);
                }
                case PRODUCER: {
                    return this.producer.getAndSet(0L);
                }
                case CONSUMER: {
                    return this.consumer.getAndSet(0L);
                }
            }
            return 0L;
        }
    }

    public static final class CounterNames {
        public static final String SQL_STATEMENT_SANITIZER_CACHE_MISS = "SqlStatementSanitizer cache miss";

        private CounterNames() {
        }
    }
}

