/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.ContextPropagationDebug;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapGetter;
import java.util.logging.Level;
import javax.annotation.Nullable;

final class PropagatingFromUpstreamInstrumenter<REQUEST, RESPONSE>
extends Instrumenter<REQUEST, RESPONSE> {
    private static final PatchLogger logger = PatchLogger.getLogger(PropagatingFromUpstreamInstrumenter.class.getName());
    private final ContextPropagators propagators;
    private final TextMapGetter<REQUEST> getter;

    PropagatingFromUpstreamInstrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder, TextMapGetter<REQUEST> getter) {
        super(builder);
        this.propagators = builder.openTelemetry.getPropagators();
        this.getter = getter;
    }

    @Override
    public Context start(Context parentContext, REQUEST request) {
        try {
            ContextPropagationDebug.debugContextLeakIfEnabled();
            Context extracted = this.propagators.getTextMapPropagator().extract(parentContext, request, this.getter);
            return super.start(extracted, request);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "start error", e);
            return parentContext;
        }
    }

    @Override
    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        try {
            super.end(context, request, response, error);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "end error", e);
        }
    }
}

