/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db;

import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.DbClientCommonAttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.MultiQuery;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesExtractorBuilder;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementInfo;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlStatementSanitizerUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.SemconvStability;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;

public final class SqlClientAttributesExtractor<REQUEST, RESPONSE>
extends DbClientCommonAttributesExtractor<REQUEST, RESPONSE, SqlClientAttributesGetter<REQUEST>> {
    private static final AttributeKey<String> DB_OPERATION = AttributeKey.stringKey("db.operation");
    private static final AttributeKey<String> DB_OPERATION_NAME = AttributeKey.stringKey("db.operation.name");
    private static final AttributeKey<String> DB_STATEMENT = AttributeKey.stringKey("db.statement");
    private static final AttributeKey<String> DB_QUERY_TEXT = AttributeKey.stringKey("db.query.text");
    static final AttributeKey<String> DB_COLLECTION_NAME = AttributeKey.stringKey("db.collection.name");
    private static final AttributeKey<Long> DB_OPERATION_BATCH_SIZE = AttributeKey.longKey("db.operation.batch.size");
    private static final AttributeKey<String> DB_QUERY_PARAMETERS = AttributeKey.stringKey("db.statement.parameters");
    private static final String SQL_CALL = "CALL";
    private final AttributeKey<String> oldSemconvTableAttribute;
    private final boolean statementSanitizationEnabled;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return SqlClientAttributesExtractor.builder(getter).build();
    }

    public static <REQUEST, RESPONSE> SqlClientAttributesExtractorBuilder<REQUEST, RESPONSE> builder(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientAttributesExtractorBuilder(getter);
    }

    SqlClientAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter, AttributeKey<String> oldSemconvTableAttribute, boolean statementSanitizationEnabled) {
        super(getter);
        this.oldSemconvTableAttribute = oldSemconvTableAttribute;
        this.statementSanitizationEnabled = statementSanitizationEnabled;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String operation;
        SqlStatementInfo sanitizedStatement;
        String rawQueryText;
        boolean isBatch;
        super.onStart(attributes, parentContext, request);
        Collection<String> rawQueryTexts = ((SqlClientAttributesGetter)this.getter).getRawQueryTexts(request);
        if (rawQueryTexts.isEmpty()) {
            return;
        }
        Long batchSize = ((SqlClientAttributesGetter)this.getter).getBatchSize(request);
        boolean bl = isBatch = batchSize != null && batchSize > 1L;
        if (SemconvStability.emitOldDatabaseSemconv() && rawQueryTexts.size() == 1) {
            rawQueryText = rawQueryTexts.iterator().next();
            sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
            operation = sanitizedStatement.getOperation();
            AttributesExtractorUtil.internalSet(attributes, DB_STATEMENT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
            AttributesExtractorUtil.internalSet(attributes, DB_OPERATION, operation);
            if (!SQL_CALL.equals(operation)) {
                AttributesExtractorUtil.internalSet(attributes, this.oldSemconvTableAttribute, sanitizedStatement.getMainIdentifier());
            }
        }
        if (SemconvStability.emitStableDatabaseSemconv()) {
            if (isBatch) {
                AttributesExtractorUtil.internalSet(attributes, DB_OPERATION_BATCH_SIZE, batchSize);
            }
            if (rawQueryTexts.size() == 1) {
                rawQueryText = rawQueryTexts.iterator().next();
                sanitizedStatement = SqlStatementSanitizerUtil.sanitize(rawQueryText);
                operation = sanitizedStatement.getOperation();
                AttributesExtractorUtil.internalSet(attributes, DB_QUERY_TEXT, this.statementSanitizationEnabled ? sanitizedStatement.getFullStatement() : rawQueryText);
                AttributesExtractorUtil.internalSet(attributes, DB_OPERATION_NAME, isBatch ? "BATCH " + operation : operation);
                if (!SQL_CALL.equals(operation)) {
                    AttributesExtractorUtil.internalSet(attributes, DB_COLLECTION_NAME, sanitizedStatement.getMainIdentifier());
                }
            } else {
                MultiQuery multiQuery = MultiQuery.analyze(((SqlClientAttributesGetter)this.getter).getRawQueryTexts(request), this.statementSanitizationEnabled);
                AttributesExtractorUtil.internalSet(attributes, DB_QUERY_TEXT, SqlClientAttributesExtractor.join("; ", multiQuery.getStatements()));
                String operation2 = multiQuery.getOperation() != null ? "BATCH " + multiQuery.getOperation() : "BATCH";
                AttributesExtractorUtil.internalSet(attributes, DB_OPERATION_NAME, operation2);
                if (!(multiQuery.getMainIdentifier() == null || multiQuery.getOperation() != null && SQL_CALL.equals(multiQuery.getOperation()))) {
                    AttributesExtractorUtil.internalSet(attributes, DB_COLLECTION_NAME, multiQuery.getMainIdentifier());
                }
            }
        }
        Map<String, String> queryParameters = ((SqlClientAttributesGetter)this.getter).getQueryParameters(request);
        SqlClientAttributesExtractor.setQueryParameters(attributes, isBatch, queryParameters);
    }

    private static void setQueryParameters(AttributesBuilder attributes, boolean isBatch, Map<String, String> queryParameters) {
        if (!isBatch && queryParameters != null && !queryParameters.isEmpty()) {
            ArrayList<String> paramList = new ArrayList<String>(queryParameters.size());
            queryParameters.entrySet().stream().sorted(Map.Entry.comparingByKey()).limit(128L).forEach(entry -> paramList.add((String)entry.getValue()));
            String paramStr = "[" + SqlClientAttributesExtractor.join(",", paramList) + "]";
            AttributesExtractorUtil.internalSet(attributes, DB_QUERY_PARAMETERS, paramStr);
        }
    }

    private static String join(String delimiter, Collection<String> collection) {
        StringBuilder builder = new StringBuilder();
        for (String string : collection) {
            if (builder.length() != 0) {
                builder.append(delimiter);
            }
            builder.append(string);
        }
        return builder.toString();
    }
}

