/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Random;
import javax.annotation.Nullable;

public final class IpAddressUtil {
    @Nullable
    private static volatile List<String> ipv4List;
    @Nullable
    private static volatile String ipV4;

    private IpAddressUtil() {
    }

    @Nullable
    private static List<String> getAllIpV4() {
        if (ipv4List == null) {
            ipv4List = new ArrayList<String>();
            try {
                Enumeration<NetworkInterface> interfs = NetworkInterface.getNetworkInterfaces();
                while (interfs.hasMoreElements()) {
                    NetworkInterface networkInterface = interfs.nextElement();
                    Enumeration<InetAddress> inetAddresses = networkInterface.getInetAddresses();
                    while (inetAddresses.hasMoreElements()) {
                        String addressStr;
                        InetAddress address = inetAddresses.nextElement();
                        if (!(address instanceof Inet4Address) || "127.0.0.1".equals(addressStr = address.getHostAddress()) || "localhost".equals(addressStr)) continue;
                        ipv4List.add(addressStr);
                    }
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }
        return ipv4List;
    }

    @Nullable
    private static String getMacAddress() {
        try {
            InetAddress ip = InetAddress.getLocalHost();
            NetworkInterface network = NetworkInterface.getByInetAddress(ip);
            byte[] mac = network.getHardwareAddress();
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < mac.length; ++i) {
                sb.append(String.format(Locale.getDefault(), "%02X%s", mac[i], i < mac.length - 1 ? "-" : ""));
            }
            return sb.toString();
        }
        catch (SocketException | UnknownHostException iOException) {
            return null;
        }
    }

    @Nullable
    private static String getHost() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException unknownHostException) {
            return null;
        }
    }

    private static String getRandomIp() {
        String alphabet = "abcdefghijklmnopqrstuvwxyz0123456789";
        StringBuilder sb = new StringBuilder("inst_");
        Random random = new Random();
        for (int i = 0; i < 8; ++i) {
            sb.append(alphabet.charAt(random.nextInt(alphabet.length())));
        }
        return sb.toString();
    }

    public static String getIpAddress() {
        if (ipV4 == null) {
            return "<unknown>";
        }
        return ipV4;
    }

    static {
        List<String> allIpV4 = IpAddressUtil.getAllIpV4();
        if (allIpV4 != null && !allIpV4.isEmpty()) {
            ipV4 = allIpV4.get(0);
        }
        if (ipV4 == null) {
            ipV4 = IpAddressUtil.getHost();
        }
        if (ipV4 == null) {
            ipV4 = IpAddressUtil.getMacAddress();
        }
        if (ipV4 == null) {
            ipV4 = IpAddressUtil.getRandomIp();
        }
    }
}

