/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.selfmonitor;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.GlobalProfilerConfigProvider;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterProvider;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.IntSupplier;

public class SelfMonitorMetrics {
    private static final String METRIC_PREFIX = "self_monitor_";
    private static final Map<Object, Long> costRecordMap = new ConcurrentHashMap<Object, Long>();
    private static final Map<String, Attributes> attributesMap = new ConcurrentHashMap<String, Attributes>();
    private static volatile boolean init = false;
    private static DoubleHistogram packageSizeHistogram;
    private static DoubleHistogram packageResponseTimeHistogram;
    private static IntSupplier spanQueueSizeSupplier;
    private static IntSupplier spanExportBatchSizeSupplier;
    public static final AttributeKey<String> TYPE;
    public static final AttributeKey<String> PROTOCOL;
    public static final AttributeKey<String> STATUS;

    private SelfMonitorMetrics() {
    }

    private static synchronized void initSelfMonitorMetric() {
        if (!init && GlobalProfilerConfigProvider.isRegistered()) {
            MeterProvider deltaMeterBuilder = GlobalProfilerConfigProvider.get().getDeltaMeterBuilder();
            Meter meter = deltaMeterBuilder.meterBuilder("Self-Monitor").build();
            packageSizeHistogram = meter.histogramBuilder("self_monitor_package_size").setUnit("By").setDescription("package size of oltp data").setExplicitBucketBoundariesAdvice(Arrays.asList(500.0, 1000.0, 1500.0, 2500.0, 5000.0, 7500.0, 10000.0, 15000.0, 20000.0, 25000.0, 50000.0, 75000.0, 100000.0, 250000.0, 500000.0, 1000000.0, 1500000.0, 2000000.0, 2500000.0, 3000000.0, 3500000.0, 4000000.0, 4500000.0, 5000000.0, 7500000.0, 1.0E7, 5.0E7, 1.0E8)).build();
            packageResponseTimeHistogram = meter.histogramBuilder("self_monitor_package_response_time").setUnit("ms").setDescription("package response time of oltp data").setExplicitBucketBoundariesAdvice(Arrays.asList(0.0, 50.0, 100.0, 150.0, 200.0, 300.0, 400.0, 500.0, 700.0, 900.0, 1100.0, 1300.0, 1500.0, 1700.0, 1900.0, 2400.0, 2900.0, 3500.0, 4000.0, 5000.0, 6000.0, 7000.0, 8000.0, 9000.0, 10000.0, 15000.0, 20000.0, 30000.0, 40000.0, 50000.0, 60000.0, 90000.0, 120000.0)).build();
            meter.gaugeBuilder("self_monitor_span_queue_size").setUnit("1").setDescription("span queue size").ofLongs().buildWithCallback(callback -> {
                if (SelfMonitorMetrics.enable() && spanQueueSizeSupplier != null) {
                    callback.record(spanQueueSizeSupplier.getAsInt());
                }
            });
            meter.gaugeBuilder("self_monitor_span_export_batch_size").setUnit("1").setDescription("span export batch size").ofLongs().buildWithCallback(callback -> {
                if (SelfMonitorMetrics.enable() && spanExportBatchSizeSupplier != null) {
                    callback.record(spanExportBatchSizeSupplier.getAsInt());
                }
            });
            init = true;
        }
    }

    private static boolean enable() {
        if (!init) {
            SelfMonitorMetrics.initSelfMonitorMetric();
        }
        return init;
    }

    public static void packageSizeMonitor(Attributes attributes, long size) {
        if (SelfMonitorMetrics.enable()) {
            packageSizeHistogram.record(size, attributes);
        }
    }

    public static void packageResponseTimeMonitor(Attributes attributes, long time) {
        if (SelfMonitorMetrics.enable()) {
            packageResponseTimeHistogram.record(time, attributes);
        }
    }

    public static void setSpanQueueSizeMonitorCallBack(IntSupplier supplier) {
        spanQueueSizeSupplier = supplier;
    }

    public static void setSpanExportBatchSizeMonitorCallBack(IntSupplier supplier) {
        spanExportBatchSizeSupplier = supplier;
    }

    public static void startRecord(Object key) {
        if (SelfMonitorMetrics.enable()) {
            costRecordMap.put(key, System.currentTimeMillis());
        }
    }

    public static Long stopRecord(Object key) {
        if (costRecordMap.containsKey(key)) {
            Long startTime = costRecordMap.remove(key);
            if (SelfMonitorMetrics.enable()) {
                return System.currentTimeMillis() - startTime;
            }
        }
        return 0L;
    }

    public static void registerAttributes(String key, Attributes attributes) {
        attributesMap.put(key, attributes);
    }

    public static Attributes getAttributes(String key) {
        return attributesMap.get(key);
    }

    static {
        TYPE = AttributeKey.stringKey("type");
        PROTOCOL = AttributeKey.stringKey("protocol");
        STATUS = AttributeKey.stringKey("status");
    }
}

