/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.metrics.threadpool;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.MetricReportController;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.function.LongSupplier;

public final class APMThreadPoolMetrics {
    static final AttributeKey<String> POOL_NAME = AttributeKey.stringKey("pool.name");
    static final AttributeKey<String> POOL_TYPE = AttributeKey.stringKey("pool.type");
    static final AttributeKey<String> POOL_TAG = AttributeKey.stringKey("pool.tag");
    static final AttributeKey<String> METRIC_NAME = AttributeKey.stringKey("name");
    static final String THREAD_POOL_TAG = "thread";
    private final Meter meter;
    private final Attributes corePoolSizeAttributes;
    private final Attributes maxPoolSizeAttributes;
    private final Attributes activeThreadNumAttributes;
    private final Attributes currentQueueSizeAttributes;
    private final Attributes currentTaskNumAttributes;

    public static APMThreadPoolMetrics create(OpenTelemetry openTelemetry, String instrumentationName, String poolName, String poolType) {
        MeterBuilder meterBuilder = openTelemetry.getMeterProvider().meterBuilder(instrumentationName);
        String version = EmbeddedInstrumentationProperties.findVersion(instrumentationName);
        if (version != null) {
            meterBuilder.setInstrumentationVersion(version);
        }
        return new APMThreadPoolMetrics(meterBuilder.build(), Attributes.of(POOL_NAME, poolName, POOL_TYPE, poolType, POOL_TAG, THREAD_POOL_TAG));
    }

    public static String getThreadPoolName(ThreadFactory factory, String defaultName, String prefix) {
        Field field = APMThreadPoolMetrics.getDeclaredField(factory, prefix);
        if (field != null) {
            field.setAccessible(true);
            String threadPoolName = null;
            try {
                threadPoolName = (String)field.get(factory);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (threadPoolName != null && threadPoolName.length() > 0) {
                return threadPoolName + "*";
            }
        }
        return defaultName;
    }

    public static String getThreadPoolName(AbstractExecutorService abstractExecutorService, String defaultName, String prefix) {
        if (abstractExecutorService == null) {
            return defaultName;
        }
        ThreadFactory factory = null;
        try {
            factory = (ThreadFactory)abstractExecutorService.getClass().getDeclaredMethod("getThreadFactory", new Class[0]).invoke((Object)abstractExecutorService, new Object[0]);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException reflectiveOperationException) {
            // empty catch block
        }
        return APMThreadPoolMetrics.getThreadPoolName(factory, defaultName, prefix);
    }

    private static Field getDeclaredField(Object object, String fieldName) {
        Field field = null;
        for (Class<?> clazz = object.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                field = clazz.getDeclaredField(fieldName);
                return field;
            }
            catch (Exception var5) {
                continue;
            }
        }
        return null;
    }

    APMThreadPoolMetrics(Meter meter, Attributes attributes) {
        this.meter = meter;
        this.corePoolSizeAttributes = attributes.toBuilder().put(METRIC_NAME, "thread_pool_core_pool_size").build();
        this.maxPoolSizeAttributes = attributes.toBuilder().put(METRIC_NAME, "thread_pool_max_pool_size").build();
        this.activeThreadNumAttributes = attributes.toBuilder().put(METRIC_NAME, "thread_pool_active_count").build();
        this.currentQueueSizeAttributes = attributes.toBuilder().put(METRIC_NAME, "thread_pool_size").build();
        this.currentTaskNumAttributes = attributes.toBuilder().put(METRIC_NAME, "thread_pool_task_count").build();
    }

    public ObservableLongUpDownCounter corePoolSize(LongSupplier corePoolSizeGetter) {
        return this.meter.upDownCounterBuilder("thread_core_pool_size").setUnit("threads").setDescription("core thread num in the thread pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(corePoolSizeGetter.getAsLong(), this.corePoolSizeAttributes);
        });
    }

    public ObservableLongUpDownCounter maxPoolSize(LongSupplier maxPoolSizeGetter) {
        return this.meter.upDownCounterBuilder("thread_max_pool_size").setUnit("threads").setDescription("max thread num in the thread pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(maxPoolSizeGetter.getAsLong(), this.maxPoolSizeAttributes);
        });
    }

    public ObservableLongUpDownCounter activeThreadNum(LongSupplier activeThreadNumGetter) {
        return this.meter.upDownCounterBuilder("thread_active_pool_size").setUnit("threads").setDescription("active thread num in the thread pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(activeThreadNumGetter.getAsLong(), this.activeThreadNumAttributes);
        });
    }

    public ObservableLongUpDownCounter currentPoolSize(LongSupplier currentQueueSizeGetter) {
        return this.meter.upDownCounterBuilder("thread_pool_size").setUnit("threads").setDescription("thread num in the thread pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(currentQueueSizeGetter.getAsLong(), this.currentQueueSizeAttributes);
        });
    }

    public ObservableLongUpDownCounter currentQueueSize(LongSupplier currentTaskNumGetter) {
        return this.meter.upDownCounterBuilder("thread_queue_size").setUnit("threads").setDescription("queue size in the thread pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(currentTaskNumGetter.getAsLong(), this.currentTaskNumAttributes);
        });
    }
}

