/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.http;

import com.google.auto.value.AutoValue;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.GlobalProfilerConfigProvider;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpRouteState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.MetricReportController;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.http.AutoValue_HttpServerMetrics_State;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.http.HttpMetricsViewAdvice;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.util.MetricViewUtil;
import java.util.logging.Level;

public class HttpServerMetrics
implements OperationListener {
    private static final ContextKey<State> HTTP_SERVER_REQUEST_METRICS_STATE = ContextKey.named("http-server-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(HttpServerMetrics.class.getName());
    private final LongCounter activeRequests;
    private final DoubleHistogram duration;

    public static OperationMetrics get() {
        return HttpServerMetrics::new;
    }

    private HttpServerMetrics(Meter meter) {
        MeterBuilder builder = GlobalProfilerConfigProvider.get().getDeltaMeterBuilder().meterBuilder("httpserver");
        Meter apmMeter = builder.build();
        this.activeRequests = apmMeter.counterBuilder("active_requests").setUnit("requests").setDescription("The number of concurrent http server requests that are currently in-flight").build();
        this.duration = apmMeter.histogramBuilder("duration").setUnit("ms").setDescription("The duration of the inbound http server request").build();
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        if (MetricReportController.shouldInterruptReportMetric()) {
            return context;
        }
        return context.with(HTTP_SERVER_REQUEST_METRICS_STATE, new AutoValue_HttpServerMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        if (MetricReportController.shouldInterruptReportMetric()) {
            return;
        }
        State state = context.get(HTTP_SERVER_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record HTTP server request metrics.", context);
            return;
        }
        endAttributes = HttpServerMetrics.updateOperation(context, endAttributes);
        this.activeRequests.add(1L, MetricViewUtil.applyView(state.startAttributes(), endAttributes, HttpMetricsViewAdvice.getConfigViewSet()), context);
        this.duration.record((double)(endNanos - state.startTimeNanos()) / MetricViewUtil.NANOS_PER_MS, MetricViewUtil.applyView(state.startAttributes(), endAttributes, HttpMetricsViewAdvice.getConfigViewSet()), context);
    }

    private static Attributes updateOperation(Context context, Attributes attributes) {
        HttpRouteState httpRouteState = HttpRouteState.fromContextOrNull(context);
        if (httpRouteState == null) {
            return attributes;
        }
        String newHttpRoute = httpRouteState.getMethod() + " " + httpRouteState.getRoute();
        return attributes.toBuilder().put(SemanticAttributes.HTTP_ROUTE, newHttpRoute).put(SemanticAttributes.OPERATION, newHttpRoute).build();
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

