/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.client;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.HttpRouteState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public final class EntryOperationAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    public static <REQUEST, RESPONSE> EntryOperationAttributesExtractor<REQUEST, RESPONSE> create() {
        return new EntryOperationAttributesExtractor<REQUEST, RESPONSE>();
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        SpanContext spanContext = Span.fromContext(parentContext).getSpanContext();
        String entryOperation = spanContext.getTraceState().get("tencent-entry-operation");
        HttpRouteState httpRouteState = HttpRouteState.fromContextOrNull(parentContext);
        if (httpRouteState != null) {
            entryOperation = httpRouteState.getMethod() + " " + httpRouteState.getRoute();
        }
        if (entryOperation != null && !entryOperation.isEmpty()) {
            attributes.put(SemanticAttributes.ENTRY_OPERATION, entryOperation);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

