/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.asm;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.securitycheckapi.SecurityCheckResult;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.asm.AsmAttributesGetter;
import javax.annotation.Nullable;

public class AsmAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private static final String REMOTECOMMANDEXECTION_PRE = "A03";
    private static final String MEMORYSHELL_PRE = "A37";
    private static final String ATTACK_PRE = "A44";
    private static final String TEMPLATE_INJECT = "A38";
    private static final String SCRIPT_INJECT = "A39";
    private static final String EXPRESSION_INJECT = "A40";
    private static final String JNDI_INJECT = "A41";
    private static final String JNI_INJECT = "A42";
    private static final String DETECTPOINT = "detectPoint";
    private static final String DETECTMETHOD = "detectMethod";
    private static final String ATTACKSTACK = "attackStack";
    public static final AttributeKey<String> ATTACK_URL = AttributeKey.stringKey("attack.url");
    public static final AttributeKey<String> ATTACK_URI = AttributeKey.stringKey("attack.uri");
    private final AsmAttributesGetter<REQUEST> getter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(AsmAttributesGetter<REQUEST> getter) {
        return new AsmAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    private AsmAttributesExtractor(AsmAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        SecurityCheckResult securityCheckResult = this.getter.getResult(request);
        if (securityCheckResult == null) {
            return;
        }
        if (securityCheckResult.getDetectType().startsWith(REMOTECOMMANDEXECTION_PRE) || securityCheckResult.getDetectType().startsWith(TEMPLATE_INJECT) || securityCheckResult.getDetectType().startsWith(SCRIPT_INJECT) || securityCheckResult.getDetectType().startsWith(EXPRESSION_INJECT) || securityCheckResult.getDetectType().startsWith(JNDI_INJECT) || securityCheckResult.getDetectType().startsWith(JNI_INJECT)) {
            this.setRemoteCommandExectionAttribute(attributes, securityCheckResult);
        } else if (securityCheckResult.getDetectType().startsWith(MEMORYSHELL_PRE) || securityCheckResult.getDetectType().startsWith(ATTACK_PRE)) {
            this.setMemoryShellAttribute(attributes, securityCheckResult);
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }

    public void setRemoteCommandExectionAttribute(AttributesBuilder attributes, SecurityCheckResult securityCheckResult) {
        attributes.put(SemanticAttributes.ATTACK_PAYLOAD, securityCheckResult.getPayload());
        attributes.put(SemanticAttributes.DETECT_TYPE, securityCheckResult.getDetectType());
        attributes.put(SemanticAttributes.ATTACK_CLASS_METHOD, securityCheckResult.getClassMethod());
    }

    public void setMemoryShellAttribute(AttributesBuilder attributes, SecurityCheckResult securityCheckResult) {
        attributes.put(SemanticAttributes.ATTACK_PAYLOAD, securityCheckResult.getPayload());
        attributes.put(SemanticAttributes.ATTACK_CLASS_METHOD, securityCheckResult.getParameter(DETECTPOINT));
        attributes.put(SemanticAttributes.DETECT_TYPE, securityCheckResult.getDetectType());
        attributes.put(SemanticAttributes.DETECT_METHOD, securityCheckResult.getParameter(DETECTMETHOD));
        attributes.put(SemanticAttributes.ATTACK_STACK, securityCheckResult.getParameter(ATTACKSTACK));
    }
}

