/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.dependencyapi;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.dependencyapi.DependencyGetter;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.IllegalClassFormatException;
import java.security.ProtectionDomain;
import java.util.HashSet;
import java.util.Set;

public class DependencyClassFileTransformer
implements ClassFileTransformer {
    private static final Set<String> processedCodeSources = new HashSet<String>();

    @Override
    @CanIgnoreReturnValue
    public byte[] transform(ClassLoader loader, String className, Class<?> classBeingRedefined, ProtectionDomain protectionDomain, byte[] classfileBuffer) throws IllegalClassFormatException {
        String codeSourceLocation;
        if (protectionDomain != null && protectionDomain.getCodeSource() != null && protectionDomain.getCodeSource().getLocation() != null && !(codeSourceLocation = protectionDomain.getCodeSource().getLocation().toString()).contains("opentelemetry") && !processedCodeSources.contains(codeSourceLocation)) {
            DependencyGetter.getInstance().addJarPath(protectionDomain);
            processedCodeSources.add(codeSourceLocation);
        }
        return classfileBuffer;
    }
}

