/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.checkcacheapi;

import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.checkcacheapi.SecurityCheckParam;

public interface SecurityCacheApi {
    public static SecurityCacheApi empty() {
        return EmptySecurityCache.INSTANCE;
    }

    public boolean isInWhitelist(SecurityCheckParam var1);

    public Boolean getCachedResult(SecurityCheckParam var1);

    public void cacheResult(SecurityCheckParam var1, boolean var2);

    public int getAccessCount(SecurityCheckParam var1);

    public void addToWhitelist(SecurityCheckParam var1);

    public void removeFromWhitelist(SecurityCheckParam var1);

    public void clearCache();

    public String getScenarioId();

    public int getWhitelistThreshold();

    default public boolean isInitialized() {
        return true;
    }

    default public SecurityCacheApi getScenarioCache(String scenarioId, int maxSize, long expireMinutes, int whitelistThreshold) {
        return this;
    }

    default public boolean supportsMultipleScenarios() {
        return false;
    }

    public static class EmptySecurityCache
    implements SecurityCacheApi {
        static final EmptySecurityCache INSTANCE = new EmptySecurityCache();

        private EmptySecurityCache() {
        }

        @Override
        public boolean isInWhitelist(SecurityCheckParam param) {
            return false;
        }

        @Override
        public Boolean getCachedResult(SecurityCheckParam param) {
            return null;
        }

        @Override
        public void cacheResult(SecurityCheckParam param, boolean result) {
        }

        @Override
        public int getAccessCount(SecurityCheckParam param) {
            return 0;
        }

        @Override
        public void addToWhitelist(SecurityCheckParam param) {
        }

        @Override
        public void removeFromWhitelist(SecurityCheckParam param) {
        }

        @Override
        public void clearCache() {
        }

        @Override
        public String getScenarioId() {
            return "empty-cache";
        }

        @Override
        public int getWhitelistThreshold() {
            return Integer.MAX_VALUE;
        }

        @Override
        public boolean isInitialized() {
            return false;
        }

        @Override
        public SecurityCacheApi getScenarioCache(String scenarioId, int maxSize, long expireMinutes, int whitelistThreshold) {
            return this;
        }

        @Override
        public boolean supportsMultipleScenarios() {
            return false;
        }

        public String toString() {
            return "EmptySecurityCache{type=empty, initialized=false}";
        }
    }
}

