/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.api;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.GlobalProfilerConfigProvider;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import java.util.logging.Level;

public class TencentInstrumenterCostHelper {
    private static final ThreadLocal<CostRecord> costLocal = new ThreadLocal();
    private static final PatchLogger log = PatchLogger.getLogger(TencentInstrumenterCostHelper.class.getName());

    private TencentInstrumenterCostHelper() {
    }

    public static void startDoStartRecord() {
        TencentInstrumenterCostHelper.start("apm.start");
    }

    public static void endDoStartRecord(Span span) {
        TencentInstrumenterCostHelper.end(span);
    }

    public static void startDoEndRecord() {
        TencentInstrumenterCostHelper.start("apm.end");
    }

    public static void endDoEndRecord(Span span) {
        TencentInstrumenterCostHelper.end(span);
    }

    private static String getInstrumenterClassName() {
        StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
        String instrumenterClassName = "";
        for (int i = 7; i < stackTrace.length; ++i) {
            StackTraceElement element = stackTrace[i];
            instrumenterClassName = element.toString();
            if (instrumenterClassName.contains("io.opentelemetry")) continue;
            instrumenterClassName = element.getClassName() + "." + element.getMethodName() + "()";
            break;
        }
        return instrumenterClassName;
    }

    private static void start(String type) {
        if (TencentInstrumenterCostHelper.shouldRecord()) {
            try {
                CostRecord costRecord = TencentInstrumenterCostHelper.newCostRecord();
                costRecord.type = type;
                costLocal.set(costRecord);
            }
            catch (RuntimeException e) {
                log.log(Level.WARNING, e.getMessage());
            }
        }
    }

    private static boolean shouldRecord() {
        return GlobalProfilerConfigProvider.get().isAgentCostRecordEnable();
    }

    private static void end(Span span) {
        CostRecord costRecord = costLocal.get();
        if (costRecord != null) {
            costRecord.endTime = System.currentTimeMillis();
            try {
                TencentInstrumenterCostHelper.setCostToSpan(span, costRecord);
            }
            finally {
                costLocal.remove();
            }
        }
    }

    private static CostRecord newCostRecord() {
        CostRecord costRecord = new CostRecord();
        costRecord.instrumenterClassName = TencentInstrumenterCostHelper.getInstrumenterClassName();
        costRecord.startTime = System.currentTimeMillis();
        return costRecord;
    }

    private static void setCostToSpan(Span span, CostRecord costRecord) {
        if (span != null) {
            span.setAttribute("instrumenter.class", costRecord.instrumenterClassName);
            span.setAttribute(costRecord.type + ".cost", costRecord.endTime - costRecord.startTime);
        }
    }

    private static class CostRecord {
        String instrumenterClassName;
        Long startTime;
        Long endTime;
        String type;

        private CostRecord() {
        }
    }
}

