/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.instrumentation.agent.log.api;

import io.opentelemetry.extension.tencent.all.model.heartbeat.AgentLogConfig;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util.TencentCommonConfigUtil;
import io.opentelemetry.extension.tencent.sdk.SdkProfilerConfigProvider;
import io.opentelemetry.tencent.instrumentation.agent.log.api.AgentLogEmit;
import io.opentelemetry.tencent.instrumentation.agent.log.api.NoopAgentLogEmit;
import java.time.Instant;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.Locale;
import java.util.ServiceLoader;

public class AgentLogHolder {
    public static final DateTimeFormatter TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss:SSS", Locale.getDefault()).withZone(ZoneId.systemDefault());
    private static AgentLogEmit agentLogEmit = new NoopAgentLogEmit();

    private AgentLogHolder() {
    }

    public static AgentLogEmit getAgentLogEmitInstance() {
        return agentLogEmit;
    }

    public static void setAgentLogEmitInstance(AgentLogEmit agentLogEmit) {
        AgentLogHolder.agentLogEmit = agentLogEmit;
    }

    public static void loadAgentLogEmitInstance(ClassLoader agentClassLoader, String name) {
        if ("".equals(name) || name == null) {
            name = "tencent-agent-log";
        }
        ServiceLoader<AgentLogEmit> serviceLoader = ServiceLoader.load(AgentLogEmit.class, agentClassLoader);
        for (AgentLogEmit emit : serviceLoader) {
            if (!name.equals(emit.name())) continue;
            emit.init();
            AgentLogHolder.setAgentLogEmitInstance(emit);
            break;
        }
    }

    public static String fastStackTrace(Throwable t, int maxFrames) {
        StackTraceElement[] stack = t.getStackTrace();
        int len = Math.min(maxFrames, stack.length);
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < len; ++i) {
            sb.append(stack[i].toString()).append('\n');
        }
        return sb.toString();
    }

    public static void processLog(String threadName, String level, String className, String message, Throwable error) {
        if (TencentCommonConfigUtil.isTestMode()) {
            return;
        }
        if (error != null) {
            message = message + "\n" + error;
            message = message + AgentLogHolder.fastStackTrace(error, 15);
        }
        String time = TIME_FORMATTER.format(Instant.now());
        agentLogEmit.emitLog(time, threadName, level, className, message);
    }

    public static boolean canEmit(String level) {
        String agentLogLevel;
        AgentLogConfig agentLogConfig = SdkProfilerConfigProvider.getAgentLogConfig();
        if (agentLogConfig == null) {
            return false;
        }
        if (!agentLogConfig.getAgentLogEnable().booleanValue()) {
            return false;
        }
        switch (agentLogLevel = agentLogConfig.getAgentLogLevel()) {
            case "DEBUG": {
                return level.equals("DEBUG") || level.equals("INFO") || level.equals("WARN") || level.equals("ERROR");
            }
            case "INFO": {
                return level.equals("INFO") || level.equals("WARN") || level.equals("ERROR");
            }
            case "WARN": {
                return level.equals("WARN") || level.equals("ERROR");
            }
            case "ERROR": {
                return level.equals("ERROR");
            }
        }
        return false;
    }
}

