/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.Instrumenter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.InstrumenterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.ContextPropagators;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.propagation.TextMapSetter;
import java.util.logging.Level;
import javax.annotation.Nullable;

final class PropagatingToDownstreamInstrumenter<REQUEST, RESPONSE>
extends Instrumenter<REQUEST, RESPONSE> {
    private static final PatchLogger logger = PatchLogger.getLogger(PropagatingToDownstreamInstrumenter.class.getName());
    private final ContextPropagators propagators;
    private final TextMapSetter<REQUEST> setter;

    PropagatingToDownstreamInstrumenter(InstrumenterBuilder<REQUEST, RESPONSE> builder, TextMapSetter<REQUEST> setter) {
        super(builder);
        this.propagators = builder.openTelemetry.getPropagators();
        this.setter = setter;
    }

    @Override
    public Context start(Context parentContext, REQUEST request) {
        try {
            Context newContext = super.start(parentContext, request);
            this.propagators.getTextMapPropagator().inject(newContext, request, this.setter);
            return newContext;
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "start error", e);
            return parentContext;
        }
    }

    @Override
    public void end(Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        try {
            super.end(context, request, response, error);
        }
        catch (Throwable e) {
            logger.log(Level.SEVERE, "end error", e);
        }
    }
}

