/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Locale;
import java.util.function.Consumer;

public final class StringUtils {
    private StringUtils() {
    }

    public static boolean isEmpty(String str) {
        return str == null || str.isEmpty();
    }

    public static boolean isNotEmpty(String str) {
        return !StringUtils.isEmpty(str);
    }

    public static boolean isBlank(String str) {
        return str == null || StringUtils.isEmpty(str.trim());
    }

    public static boolean isNotBlank(String str) {
        return !StringUtils.isBlank(str);
    }

    public static void setIfPresent(String value, Consumer<String> setter) {
        if (StringUtils.isNotEmpty(value)) {
            setter.accept(value);
        }
    }

    public static String join(char delimiter, String ... strings) {
        if (strings.length == 0) {
            return "";
        }
        if (strings.length == 1) {
            return strings[0];
        }
        int length = strings.length - 1;
        for (String s : strings) {
            if (s == null) continue;
            length += s.length();
        }
        StringBuilder sb = new StringBuilder(length);
        if (strings[0] != null) {
            sb.append(strings[0]);
        }
        for (int i = 1; i < strings.length; ++i) {
            if (!StringUtils.isEmpty(strings[i])) {
                sb.append(delimiter).append(strings[i]);
                continue;
            }
            sb.append(delimiter);
        }
        return sb.toString();
    }

    public static boolean substringMatch(CharSequence str, int index, CharSequence substring) {
        if (index + substring.length() > str.length()) {
            return false;
        }
        for (int i = 0; i < substring.length(); ++i) {
            if (str.charAt(index + i) == substring.charAt(i)) continue;
            return false;
        }
        return true;
    }

    public static String cut(String str, int threshold) {
        if (StringUtils.isEmpty(str) || str.length() <= threshold) {
            return str;
        }
        return str.substring(0, threshold);
    }

    public static String md5Sum(String origin) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] inputBytes = origin.getBytes(StandardCharsets.UTF_8);
            byte[] md5Bytes = md.digest(inputBytes);
            StringBuilder sb = new StringBuilder();
            for (byte b : md5Bytes) {
                sb.append(String.format(Locale.getDefault(), "%02x", b & 0xFF));
            }
            return sb.toString();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            return "";
        }
    }

    public static String md5TraceId(String origin) {
        return StringUtils.md5Sum(origin);
    }

    public static String md5SpanId(String origin) {
        String result = StringUtils.md5Sum(origin);
        if (result.length() > 16) {
            return result.substring(0, 16);
        }
        return "";
    }
}

