/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.threadpool;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicInteger;

public class AgentTaskThreadFactory
implements ThreadFactory {
    private final ThreadGroup group;
    private final String poolName;
    private final AtomicInteger threadNumber = new AtomicInteger(1);

    public AgentTaskThreadFactory(String poolName, String threadGroupName) {
        SecurityManager s = System.getSecurityManager();
        this.group = s != null ? s.getThreadGroup() : new ThreadGroup(threadGroupName);
        this.poolName = poolName;
    }

    @Override
    public Thread newThread(Runnable r) {
        Thread t = new Thread(this.group, r, this.poolName + "-thread-" + this.threadNumber.getAndIncrement(), 0L);
        t.setDaemon(true);
        return t;
    }
}

