/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.threadpool;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.threadpool.AgentTaskMetricsRecord;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.threadpool.AgentTaskThreadFactory;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.threadpool.AgentTaskTypeProvider;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;

public class AgentTaskExecutorManager {
    private static final PatchLogger logger = PatchLogger.getLogger(AgentTaskExecutorManager.class.getName());
    private static final Map<String, AgentTaskTypeProvider> TYPE_PROVIDER = new ConcurrentHashMap<String, AgentTaskTypeProvider>();
    private static final ScheduledExecutorService CANCELLER;

    private AgentTaskExecutorManager() {
    }

    public static void registerProvider(AgentTaskTypeProvider provider) {
        if (provider != null && provider.type() != null) {
            TYPE_PROVIDER.put(provider.type(), provider);
        }
    }

    public static Optional<Future<?>> submit(String type, Runnable task) {
        if (task == null) {
            logger.log(Level.WARNING, "AgentTaskExecutorManager submit task is null [" + type + "]");
            return Optional.empty();
        }
        Callable<Object> callable = Executors.callable(task);
        return AgentTaskExecutorManager.submitInternal(type, callable);
    }

    public static Optional<Future<?>> submit(String type, Callable<?> task) {
        if (task == null) {
            logger.log(Level.WARNING, "AgentTaskExecutorManager submit task is null [" + type + "]");
            return Optional.empty();
        }
        return AgentTaskExecutorManager.submitInternal(type, task);
    }

    private static Optional<Future<?>> submitInternal(String type, Callable<?> task) {
        Future<?> future;
        AgentTaskTypeProvider provider = TYPE_PROVIDER.get(type);
        if (provider == null) {
            logger.log(Level.FINE, "AgentTaskExecutorManager no provider for type: " + type);
            return Optional.empty();
        }
        try {
            future = provider.executorService().submit(task);
        }
        catch (RejectedExecutionException e) {
            AgentTaskMetricsRecord.processedAgentTaskRejectedCounter.add(1L, Attributes.of(AgentTaskMetricsRecord.TASK_TYPE, provider.type()));
            return Optional.empty();
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "AgentTaskExecutorManager submit task [" + type + "] throwable", th);
            return Optional.empty();
        }
        try {
            ScheduledFuture<?> th = CANCELLER.schedule(() -> {
                if (!future.isDone()) {
                    future.cancel(false);
                    AgentTaskMetricsRecord.processedAgentTaskTimeoutCounter.add(1L, Attributes.of(AgentTaskMetricsRecord.TASK_TYPE, provider.type()));
                }
            }, provider.timeoutMillis(), TimeUnit.MILLISECONDS);
        }
        catch (Throwable th) {
            logger.log(Level.WARNING, "AgentTaskExecutorManager error scheduling canceller for task [" + type + "]", th);
            return Optional.empty();
        }
        return Optional.of(future);
    }

    static {
        ServiceLoader<AgentTaskTypeProvider> loader = ServiceLoader.load(AgentTaskTypeProvider.class);
        for (AgentTaskTypeProvider provider : loader) {
            if (provider == null || provider.type() == null) continue;
            TYPE_PROVIDER.put(provider.type(), provider);
        }
        CANCELLER = Executors.newSingleThreadScheduledExecutor(new AgentTaskThreadFactory("DetectCanceller", "CancelGroup"));
    }
}

