/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.context;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.context.SkywalkingContextCarrierContextKey;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util.Base64;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util.GlobalIdGenerator;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util.StringUtils;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ImplicitContextKeyed;

public class SkywalkingContextCarrier
implements ImplicitContextKeyed {
    private String traceId = "";
    private String traceSegmentId = "";
    private int spanId = -1;
    private String parentService = "";
    private String parentServiceInstance = "";
    private String parentEndpoint = "unknown";
    private String addressUsedAtClient = "unknown";
    private String otParentSpanId = "";
    private boolean enabled = false;

    private SkywalkingContextCarrier() {
        this.traceSegmentId = this.traceId = GlobalIdGenerator.generate();
    }

    private SkywalkingContextCarrier(String traceId, String traceSegmentId, int spanId, String parentService, String parentServiceInstance, String parentEndpoint, String addressUsedAtClient, String otParentSpanId, boolean enabled) {
        this.traceId = traceId;
        this.traceSegmentId = traceSegmentId;
        this.spanId = spanId;
        this.parentService = parentService;
        this.parentServiceInstance = parentServiceInstance;
        this.parentEndpoint = parentEndpoint;
        this.addressUsedAtClient = addressUsedAtClient;
        this.otParentSpanId = otParentSpanId;
        this.enabled = enabled;
    }

    public String getOtParentSpanId() {
        return this.otParentSpanId;
    }

    public String getTraceSegmentId() {
        return this.traceSegmentId;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public String getTraceId() {
        return this.traceId;
    }

    public int getSpanId() {
        return this.spanId;
    }

    public void increaseSpanId() {
        ++this.spanId;
    }

    public void setParentService(String parentService) {
        this.parentService = parentService;
    }

    public void setParentServiceInstance(String serviceInstance) {
        this.parentServiceInstance = serviceInstance;
    }

    public static SkywalkingContextCarrier fromContext(Context context) {
        SkywalkingContextCarrier skywalkingContextCarrier = context.get(SkywalkingContextCarrierContextKey.KEY);
        return skywalkingContextCarrier != null ? skywalkingContextCarrier : SkywalkingContextCarrier.empty();
    }

    @Override
    public Context storeInContext(Context context) {
        return context.with(SkywalkingContextCarrierContextKey.KEY, this);
    }

    public static SkywalkingContextCarrier empty() {
        return new SkywalkingContextCarrier();
    }

    public static Builder builder(String sw8Header) {
        return new Builder(sw8Header);
    }

    public String serialize() {
        return StringUtils.join('-', "1", Base64.encode(this.traceId), Base64.encode(this.traceSegmentId), this.spanId + "", Base64.encode(this.parentService), Base64.encode(this.parentServiceInstance), Base64.encode(this.parentEndpoint), Base64.encode(this.addressUsedAtClient));
    }

    public static class Builder {
        private String traceId = "";
        private String traceSegmentId = "";
        private int spanId = -1;
        private String parentService = "";
        private String parentServiceInstance = "";
        private String parentEndpoint = "unknown";
        private String addressUsedAtClient = "unknown";
        private String otParentSpanId = "";

        Builder(String sw8Header) {
            String[] parts = sw8Header.split("-", 8);
            if (parts.length == 8) {
                try {
                    this.traceId = Base64.decode2UtfString(parts[1]);
                    this.traceSegmentId = Base64.decode2UtfString(parts[2]);
                    this.spanId = Integer.parseInt(parts[3]);
                    this.parentService = Base64.decode2UtfString(parts[4]);
                    this.parentServiceInstance = Base64.decode2UtfString(parts[5]);
                    this.parentEndpoint = Base64.decode2UtfString(parts[6]);
                    this.addressUsedAtClient = Base64.decode2UtfString(parts[7]);
                    this.otParentSpanId = StringUtils.md5SpanId(this.traceSegmentId + "." + this.spanId);
                    this.traceSegmentId = GlobalIdGenerator.generate();
                    this.spanId = 0;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }

        public SkywalkingContextCarrier build() {
            return new SkywalkingContextCarrier(this.traceId, this.traceSegmentId, this.spanId, this.parentService, this.parentServiceInstance, this.parentEndpoint, this.addressUsedAtClient, this.otParentSpanId, true);
        }
    }
}

