/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.rpc;

import com.google.auto.value.AutoValue;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.GlobalProfilerConfigProvider;
import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationListener;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.OperationMetrics;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.DoubleHistogram;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.LongCounter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.MetricReportController;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.rpc.AutoValue_RpcClientMetrics_State;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.rpc.RpcMetricsViewAdvice;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.util.MetricViewUtil;
import java.util.logging.Level;

public class RpcClientMetrics
implements OperationListener {
    private static final ContextKey<State> RPC_CLIENT_REQUEST_METRICS_STATE = ContextKey.named("rpc-client-request-metrics-state");
    private static final PatchLogger logger = PatchLogger.getLogger(RpcClientMetrics.class.getName());
    private final LongCounter activeRequests;
    private final DoubleHistogram clientDurationHistogram;

    private RpcClientMetrics(Meter meter) {
        MeterBuilder builder = GlobalProfilerConfigProvider.get().getDeltaMeterBuilder().meterBuilder("rpcclient");
        Meter apmMeter = builder.build();
        this.activeRequests = apmMeter.counterBuilder("active_requests").setUnit("requests").setDescription("The number of concurrent rpc client requests that are currently in-flight").build();
        this.clientDurationHistogram = apmMeter.histogramBuilder("duration").setDescription("The duration of an RPC client request invocation").setUnit("ms").build();
    }

    public static OperationMetrics get() {
        return RpcClientMetrics::new;
    }

    @Override
    public Context onStart(Context context, Attributes startAttributes, long startNanos) {
        if (MetricReportController.shouldInterruptReportMetric()) {
            return context;
        }
        return context.with(RPC_CLIENT_REQUEST_METRICS_STATE, new AutoValue_RpcClientMetrics_State(startAttributes, startNanos));
    }

    @Override
    public void onEnd(Context context, Attributes endAttributes, long endNanos) {
        if (MetricReportController.shouldInterruptReportMetric()) {
            return;
        }
        State state = context.get(RPC_CLIENT_REQUEST_METRICS_STATE);
        if (state == null) {
            logger.log(Level.FINE, "No state present when ending context {0}. Cannot record RPC client request metrics.", context);
            return;
        }
        this.activeRequests.add(1L, MetricViewUtil.applyView(state.startAttributes(), endAttributes, RpcMetricsViewAdvice.getConfigViewSet()), context);
        this.clientDurationHistogram.record((double)(endNanos - state.startTimeNanos()) / MetricViewUtil.NANOS_PER_MS, MetricViewUtil.applyView(state.startAttributes(), endAttributes, RpcMetricsViewAdvice.getConfigViewSet()), context);
    }

    @AutoValue
    static abstract class State {
        State() {
        }

        abstract Attributes startAttributes();

        abstract long startTimeNanos();
    }
}

