/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.metrics.connection;

import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.EmbeddedInstrumentationProperties;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.OpenTelemetry;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.Attributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.Meter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.MeterBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.metrics.ObservableLongUpDownCounter;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.MetricReportController;
import java.util.function.LongSupplier;

public final class APMConnectionPoolMetrics {
    static final AttributeKey<String> POOL_NAME = AttributeKey.stringKey("pool.name");
    static final AttributeKey<String> POOL_TYPE = AttributeKey.stringKey("pool.type");
    static final AttributeKey<String> POOL_TAG = AttributeKey.stringKey("pool.tag");
    static final AttributeKey<String> METRIC_NAME = AttributeKey.stringKey("name");
    static final String CONNECTION_POOL_TAG = "connection";
    private final Meter meter;
    private final Attributes activeConnectionCountAttributes;
    private final Attributes currentConnectionCountAttributes;
    private final Attributes maxConnectionCountAttributes;
    private final Attributes waitConnectionCountAttributes;
    private final Attributes idleConnectionCountAttributes;

    public static APMConnectionPoolMetrics create(OpenTelemetry openTelemetry, String instrumentationName, String poolName, String poolType) {
        MeterBuilder meterBuilder = openTelemetry.getMeterProvider().meterBuilder(instrumentationName);
        String version = EmbeddedInstrumentationProperties.findVersion(instrumentationName);
        if (version != null) {
            meterBuilder.setInstrumentationVersion(version);
        }
        return new APMConnectionPoolMetrics(meterBuilder.build(), Attributes.of(POOL_NAME, poolName, POOL_TYPE, poolType, POOL_TAG, CONNECTION_POOL_TAG));
    }

    APMConnectionPoolMetrics(Meter meter, Attributes attributes) {
        this.meter = meter;
        this.activeConnectionCountAttributes = attributes.toBuilder().put(METRIC_NAME, "connection_pool_active_size").build();
        this.currentConnectionCountAttributes = attributes.toBuilder().put(METRIC_NAME, "connection_pool_current_size").build();
        this.maxConnectionCountAttributes = attributes.toBuilder().put(METRIC_NAME, "connection_pool_max_size").build();
        this.waitConnectionCountAttributes = attributes.toBuilder().put(METRIC_NAME, "connection_pool_wait_size").build();
        this.idleConnectionCountAttributes = attributes.toBuilder().put(METRIC_NAME, "connection_pool_idle_size").build();
    }

    public ObservableLongUpDownCounter activeConnectionSize(LongSupplier activeConnectionSizeGetter) {
        return this.meter.upDownCounterBuilder("connection_pool_active_size").setUnit("connections").setDescription("active connection num in the connection pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(activeConnectionSizeGetter.getAsLong(), this.activeConnectionCountAttributes);
        });
    }

    public ObservableLongUpDownCounter currentConnectionSize(LongSupplier currentConnectionSizeGetter) {
        return this.meter.upDownCounterBuilder("connection_pool_current_size").setUnit("connections").setDescription("current connection num in the connection pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(currentConnectionSizeGetter.getAsLong(), this.currentConnectionCountAttributes);
        });
    }

    public ObservableLongUpDownCounter maxConnectionSize(LongSupplier maxConnectionSize) {
        return this.meter.upDownCounterBuilder("connection_pool_max_size").setUnit("connections").setDescription("max connection num in the connection pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(maxConnectionSize.getAsLong(), this.maxConnectionCountAttributes);
        });
    }

    public ObservableLongUpDownCounter waitConnectionSize(LongSupplier waitConnectionSizeGetter) {
        return this.meter.upDownCounterBuilder("connection_pool_wait_size").setUnit("connections").setDescription("wait connection num in the connection pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(waitConnectionSizeGetter.getAsLong(), this.waitConnectionCountAttributes);
        });
    }

    public ObservableLongUpDownCounter idleConnectionSize(LongSupplier idleConnectionSizeGetter) {
        return this.meter.upDownCounterBuilder("connection_pool_idle_size").setUnit("connections").setDescription("idle connection num in the connection pool").buildWithCallback(observableLongMeasurement -> {
            if (MetricReportController.shouldInterruptReportMetric()) {
                return;
            }
            observableLongMeasurement.record(idleConnectionSizeGetter.getAsLong(), this.idleConnectionCountAttributes);
        });
    }
}

