/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.error;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpCommonAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpServerAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.semconv.http.HttpStatusCodeConverter;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import javax.annotation.Nullable;

public class HttpSpanErrorStatusExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    private final HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter;
    private final HttpStatusCodeConverter statusCodeConverter;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpClientAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanErrorStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusCodeConverter.CLIENT);
    }

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(HttpServerAttributesGetter<? super REQUEST, ? super RESPONSE> getter) {
        return new HttpSpanErrorStatusExtractor<REQUEST, RESPONSE>(getter, HttpStatusCodeConverter.SERVER);
    }

    private HttpSpanErrorStatusExtractor(HttpCommonAttributesGetter<? super REQUEST, ? super RESPONSE> getter, HttpStatusCodeConverter statusCodeConverter) {
        this.getter = getter;
        this.statusCodeConverter = statusCodeConverter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
        Integer statusCode;
        if (response != null && (statusCode = this.getter.getHttpResponseStatusCode(request, response, error)) != null && this.statusCodeConverter.isError(statusCode)) {
            attributes.put(SemanticAttributes.ERROR, Boolean.valueOf(true));
            if (error != null) {
                attributes.put(SemanticAttributes.ERROR_OBJECT, error.getClass().getName());
            } else {
                String errorStatusCode = "http.status_code:" + statusCode;
                attributes.put(SemanticAttributes.ERROR_OBJECT, errorStatusCode);
            }
        }
    }
}

