/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.semconv.db;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.instrumentation.api.incubator.semconv.db.SqlClientAttributesGetter;
import io.opentelemetry.javaagent.shaded.instrumentation.api.instrumenter.AttributesExtractor;
import io.opentelemetry.javaagent.shaded.instrumentation.api.internal.AttributesExtractorUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributeKey;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.common.SecurityCheckSwitch;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.httpcontextmanagerapi.HttpContextManagerGetter;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.securitycheckapi.SecurityCheckApi;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.securitycheckapi.SecurityCheckGetter;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.securitycheckapi.SecurityCheckResult;
import javax.annotation.Nullable;

public final class SqlClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>
implements AttributesExtractor<REQUEST, RESPONSE> {
    final SqlClientAttributesGetter<REQUEST> getter;
    public static final AttributeKey<String> ATTACK_URL = AttributeKey.stringKey("attack.url");
    public static final AttributeKey<String> ATTACK_URI = AttributeKey.stringKey("attack.uri");
    public static final AttributeKey<String> ATTACK_SQL = AttributeKey.stringKey("attack.sql");
    private static final String ATTACKSQL = "attackSql";
    private static final int SQL_MAX_LENGTH = 256;

    public static <REQUEST, RESPONSE> AttributesExtractor<REQUEST, RESPONSE> create(SqlClientAttributesGetter<REQUEST> getter) {
        return new SqlClientPeerServiceAttributesExtractor<REQUEST, RESPONSE>(getter);
    }

    SqlClientPeerServiceAttributesExtractor(SqlClientAttributesGetter<REQUEST> getter) {
        this.getter = getter;
    }

    @Override
    public void onStart(AttributesBuilder attributes, Context parentContext, REQUEST request) {
        String uri;
        if (SecurityCheckSwitch.isSqlInjectionSwitch()) {
            return;
        }
        String sqlRaw = this.getter.getRawQueryText(request);
        if (sqlRaw == null || sqlRaw.length() > 256) {
            return;
        }
        SecurityCheckApi securityCheckApi = SecurityCheckGetter.getSecurityCheckApi("4");
        if (securityCheckApi == null) {
            return;
        }
        SecurityCheckResult securityCheckResult = securityCheckApi.securityCheck(null, null, null, null, sqlRaw, null, "4", null);
        if (securityCheckResult == null) {
            return;
        }
        String url = HttpContextManagerGetter.getInstance() != null ? HttpContextManagerGetter.getInstance().getRequestUrl() : null;
        String string = uri = HttpContextManagerGetter.getInstance() != null ? HttpContextManagerGetter.getInstance().getRequestUri() : null;
        if (securityCheckResult.getPayload() != null) {
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.ATTACK_PAYLOAD, securityCheckResult.getPayload());
            AttributesExtractorUtil.internalSet(attributes, SemanticAttributes.DETECT_TYPE, securityCheckResult.getDetectType());
            AttributesExtractorUtil.internalSet(attributes, ATTACK_SQL, securityCheckResult.getParameter(ATTACKSQL));
            if (url != null && !url.isEmpty() && uri != null && !uri.isEmpty()) {
                AttributesExtractorUtil.internalSet(attributes, ATTACK_URL, url);
                AttributesExtractorUtil.internalSet(attributes, ATTACK_URI, uri);
            }
        }
    }

    @Override
    public void onEnd(AttributesBuilder attributes, Context context, REQUEST request, @Nullable RESPONSE response, @Nullable Throwable error) {
    }
}

