/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.event.api;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.event.api.JvmMonitorHolder;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.event.api.JvmMonitorTransformer;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.event.api.JvmMonitorUtil;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.regex.Pattern;

public class JvmMonitorMethodTraceRecorder {
    private static final PatchLogger logger = PatchLogger.getLogger(JvmMonitorMethodTraceRecorder.class.getName());
    private static final ThreadLocal<ArrayList<MethodTraceRecord>> methodRecordStack = new ThreadLocal();
    private static final ThreadLocal<ArrayList<MethodArgumentRecord>> methodArgumentList = new ThreadLocal();
    private static final ThreadLocal<Object> mRetValue = new ThreadLocal();

    public static void removeProfileCount(String getKey, Map<String, Integer> map) {
        Iterator<Map.Entry<String, Integer>> iterator = map.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry<String, Integer> entry = iterator.next();
            String key = entry.getKey();
            String keyPattern = JvmMonitorUtil.getPatternFromString(key);
            if (!Pattern.matches(keyPattern, getKey)) continue;
            iterator.remove();
        }
    }

    public static int getProfileCount(String getKey, Map<String, Integer> map) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            String keyPattern = JvmMonitorUtil.getPatternFromString(key);
            if (!Pattern.matches(keyPattern, getKey)) continue;
            return entry.getValue();
        }
        return -1;
    }

    public static void setProfileCount(String getKey, Map<String, Integer> map, int profileCount) {
        for (Map.Entry<String, Integer> entry : map.entrySet()) {
            String key = entry.getKey();
            String keyPattern = JvmMonitorUtil.getPatternFromString(key);
            if (!Pattern.matches(keyPattern, getKey)) continue;
            entry.setValue(profileCount);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void onMethodEnter(String className, String methodSig, String loaderSig) {
        Class<JvmMonitorMethodTraceRecorder> clazz = JvmMonitorMethodTraceRecorder.class;
        synchronized (JvmMonitorMethodTraceRecorder.class) {
            String mtdName = methodSig.substring(0, methodSig.indexOf(40));
            String getKey = className + "." + mtdName;
            int profileCount = JvmMonitorMethodTraceRecorder.getProfileCount(getKey, JvmMonitorHolder.getCountTable());
            JvmMonitorTransformer transformer = JvmMonitorHolder.getJvmMonitorTransformer();
            if (profileCount > 1) {
                JvmMonitorMethodTraceRecorder.setProfileCount(getKey, JvmMonitorHolder.getCountTable(), --profileCount);
            } else if (profileCount == 1) {
                Instrumentation inst = JvmMonitorHolder.getInstrumentation();
                String clzPattern = JvmMonitorUtil.getPatternFromString(className.replace("/", "."));
                String methodPattern = JvmMonitorUtil.getPatternFromString(mtdName);
                for (Class<?> clz : transformer.getRegisteredClasses()) {
                    Method[] clzMethods;
                    String cname = clz.getName();
                    if (JvmMonitorUtil.shouldExcludeClass(cname) || !Pattern.matches(clzPattern, cname)) continue;
                    for (Method mtd : clzMethods = clz.getDeclaredMethods()) {
                        if (!Pattern.matches(methodPattern, mtd.getName())) continue;
                        transformer.removeRegisteredMethod(cname, clz, mtd);
                    }
                }
                try {
                    Set<Class<?>> classesSet = transformer.getRegisteredClasses();
                    transformer.redefineClass(inst, classesSet);
                }
                catch (UnmodifiableClassException e) {
                    logger.log(Level.SEVERE, "onMethodEnter redefine class failed", e);
                }
                JvmMonitorMethodTraceRecorder.setProfileCount(getKey, JvmMonitorHolder.getCountTable(), --profileCount);
            }
            ArrayList<MethodTraceRecord> recordStack = methodRecordStack.get();
            if (recordStack == null) {
                recordStack = new ArrayList();
                methodRecordStack.set(recordStack);
            }
            MethodTraceRecord topRecord = null;
            if (!recordStack.isEmpty()) {
                int size = recordStack.size();
                topRecord = recordStack.get(size - 1);
            }
            int layer = 0;
            if (topRecord != null) {
                layer = topRecord.layer + 1;
            }
            long time = System.currentTimeMillis();
            MethodTraceRecord record = new MethodTraceRecord(className, methodSig, loaderSig, time, layer);
            methodRecordStack.get().add(record);
            logger.log(Level.FINE, "finish create record when method { " + methodSig + " } enter");
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return;
        }
    }

    public static void onMethodExit(String className, String methodSig, String loaderSig, boolean returnNormally) {
        long time = System.currentTimeMillis();
        assert (methodRecordStack.get() != null) : "methodRecordStack is null after method call";
        assert (!methodRecordStack.get().isEmpty()) : "methodRecordStack is empty after method call";
        logger.log(Level.FINE, "finish record when method { " + methodSig + " } exit");
        ArrayList<MethodTraceRecord> recordStack = methodRecordStack.get();
        MethodTraceRecord record = recordStack.remove(recordStack.size() - 1);
        if (record == null || record.execBeginTime == 0L) {
            logger.log(Level.SEVERE, "No method enter record!");
            return;
        }
        record.threadName = Thread.currentThread().toString();
        record.execEndTime = time;
        record.execDuration = time - record.execBeginTime;
        record.returnNormally = returnNormally;
        record.returnValue = mRetValue.get() != null ? mRetValue.get() : null;
        JvmMonitorMethodTraceRecorder.commitRecord(record);
        JvmMonitorHolder.setActualCount(new AtomicInteger(JvmMonitorHolder.getActualCount().incrementAndGet()));
        assert (methodArgumentList.get() == null) : "argument list is not clean when method exit! data lose??";
        mRetValue.remove();
    }

    public static void beforeMethodCall(String owner, String name, String descriptor, int line) {
        assert (methodRecordStack.get() != null) : "methodRecordStack is null before method call";
        assert (!methodRecordStack.get().isEmpty()) : "methodRecordStack is empty before method call";
        ArrayList<MethodTraceRecord> recordStack = methodRecordStack.get();
        MethodTraceRecord record = recordStack.get(recordStack.size() - 1);
        if (record == null || record.execBeginTime == 0L) {
            logger.log(Level.SEVERE, "No method enter record!");
            return;
        }
        record.insertCallee(owner, name, descriptor, line);
    }

    public static void afterMethodCall(String owner, String name, String descriptor, int line) {
        long time = System.currentTimeMillis();
        assert (methodRecordStack.get() != null) : "methodRecordStack is null after method call";
        assert (!methodRecordStack.get().isEmpty()) : "methodRecordStack is empty after method call";
        ArrayList<MethodTraceRecord> recordStack = methodRecordStack.get();
        MethodTraceRecord record = recordStack.get(recordStack.size() - 1);
        if (record == null || record.execBeginTime == 0L) {
            logger.log(Level.SEVERE, "No method enter record!");
            return;
        }
        record.updateCallee(owner, name, descriptor, line, time);
    }

    public static void onArgumentPushBool(int idx, boolean arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, arg, isArgument);
    }

    public static void onArgumentPushChar(int idx, char arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, Character.valueOf(arg), isArgument);
    }

    public static void onArgumentPushByte(int idx, byte arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, arg, isArgument);
    }

    public static void onArgumentPushShort(int idx, short arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, arg, isArgument);
    }

    public static void onArgumentPushInt(int idx, int arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, arg, isArgument);
    }

    public static void onArgumentPushFloat(int idx, float arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, Float.valueOf(arg), isArgument);
    }

    public static void onArgumentPushDouble(int idx, double arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, arg, isArgument);
    }

    public static void onArgumentPushLong(int idx, long arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, arg, isArgument);
    }

    public static void onArgumentPushObject(int idx, Object arg, boolean isArgument) {
        JvmMonitorMethodTraceRecorder.processArgumentsAndRets(idx, arg, isArgument);
    }

    public static void onArgumentsPushFinishAll() {
        if (methodArgumentList.get() == null || methodArgumentList.get().isEmpty()) {
            return;
        }
        assert (methodRecordStack.get() != null) : "methodRecordStack is null after method call";
        assert (!methodRecordStack.get().isEmpty()) : "methodRecordStack is empty after method call";
        ArrayList<MethodTraceRecord> recordStack = methodRecordStack.get();
        MethodTraceRecord record = recordStack.get(recordStack.size() - 1);
        if (record.argsList != null) {
            logger.log(Level.SEVERE, "error when updating argList, it is not NULL: " + record.argsList);
        }
        record.argsList = methodArgumentList.get();
        methodArgumentList.remove();
    }

    private static synchronized void commitRecord(MethodTraceRecord record) {
        JvmMonitorHolder.getJvmMonitorRecordProcessor().commit(record);
    }

    private static void processArgumentsAndRets(int idx, Object arg, boolean isArgument) {
        if (!isArgument) {
            assert (mRetValue.get() == null) : "double return?";
            mRetValue.set(arg);
            return;
        }
        assert (methodArgumentList.get() == null || methodArgumentList.get().size() == idx - 1) : "Wrong argument recorded, expected: " + (idx - 1) + " but actual " + methodArgumentList.get().size();
        MethodArgumentRecord record = new MethodArgumentRecord(idx, arg);
        if (methodArgumentList.get() == null) {
            methodArgumentList.set(new ArrayList());
        }
        methodArgumentList.get().add(record);
    }

    public static class MethodTraceRecord {
        public ArrayList<MethodArgumentRecord> argsList;
        public boolean returnNormally;
        public Object returnValue;
        private String threadName;
        private int layer;
        private String className;
        private final String methodName;
        private String methodSig;
        private String loaderName;
        private long execBeginTime;
        private long execEndTime;
        private long execDuration;
        private final long offset;
        private List<InvocationTargetRecord> calleeRecordList;
        private InvocationTargetRecord currentInvocationRecord;

        public MethodTraceRecord(String className, String methodSig, String loaderName, long enterTime, int layer) {
            this.className = className.replace("/", ".");
            this.methodSig = methodSig;
            this.loaderName = loaderName;
            this.execBeginTime = enterTime;
            this.layer = layer;
            this.argsList = null;
            this.methodName = methodSig.substring(0, methodSig.indexOf(40));
            this.offset = 0L;
            String getKey = className + "." + this.methodName;
            int count = JvmMonitorMethodTraceRecorder.getProfileCount(getKey, JvmMonitorHolder.getCountTable());
            if (count == 0) {
                JvmMonitorMethodTraceRecorder.removeProfileCount(getKey, JvmMonitorHolder.getCountTable());
            }
        }

        public String getMethodName() {
            return this.methodName;
        }

        public long getOffset() {
            return this.offset;
        }

        public String getThreadName() {
            return this.threadName;
        }

        public void setThreadName(String threadName) {
            this.threadName = threadName;
        }

        public int getLayer() {
            return this.layer;
        }

        public void setLayer(int layer) {
            this.layer = layer;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public String getMethodSig() {
            return this.methodSig;
        }

        public void setMethodSig(String methodSig) {
            this.methodSig = methodSig;
        }

        public String getLoaderName() {
            return this.loaderName;
        }

        public void setLoaderName(String loaderName) {
            this.loaderName = loaderName;
        }

        public long getExecBeginTime() {
            return this.execBeginTime;
        }

        public void setExecBeginTime(long execBeginTime) {
            this.execBeginTime = execBeginTime;
        }

        public long getExecEndTime() {
            return this.execEndTime;
        }

        public void setExecEndTime(long execEndTime) {
            this.execEndTime = execEndTime;
        }

        public long getExecDuration() {
            return this.execDuration;
        }

        public void setExecDuration(long execDuration) {
            this.execDuration = execDuration;
        }

        public List<InvocationTargetRecord> getCalleeRecordList() {
            return this.calleeRecordList;
        }

        public void setCalleeRecordList(List<InvocationTargetRecord> calleeRecordList) {
            this.calleeRecordList = calleeRecordList;
        }

        public void insertCallee(String owner, String name, String descriptor, int line) {
            if (this.calleeRecordList == null) {
                this.calleeRecordList = new ArrayList<InvocationTargetRecord>();
            }
            this.currentInvocationRecord = this.getRecordInList(owner, name, descriptor, line, true);
            assert (this.currentInvocationRecord != null) : "getRecordInList() returns null, which is not possible for createIfNotExist. OOM may happened!";
            this.currentInvocationRecord.execBeginTime = System.currentTimeMillis();
            this.currentInvocationRecord.offset = this.currentInvocationRecord.execBeginTime - this.execBeginTime;
            this.currentInvocationRecord.line = line;
        }

        private InvocationTargetRecord getRecordInList(String owner, String name, String descriptor, int line, boolean createIfNotExist) {
            String sig = MethodTraceRecord.getCalleeSig(name, descriptor, line);
            for (InvocationTargetRecord r : this.calleeRecordList) {
                if (!r.calleeSig.equals(sig)) continue;
                return r;
            }
            if (createIfNotExist) {
                InvocationTargetRecord r = new InvocationTargetRecord(owner, name, sig);
                this.calleeRecordList.add(r);
                return r;
            }
            return null;
        }

        private static String getCalleeSig(String name, String descriptor, int line) {
            return name + descriptor + "#" + line;
        }

        public void updateCallee(String owner, String name, String descriptor, int line, long time) {
            String calleeSig = MethodTraceRecord.getCalleeSig(name, descriptor, line);
            InvocationTargetRecord record = this.currentInvocationRecord;
            if (!record.calleeSig.equals(calleeSig)) {
                logger.log(Level.SEVERE, "wrong invocation method signature, expected: " + calleeSig + " actual in record: " + record.calleeSig);
            }
            if (record.execBeginTime == 0L) {
                logger.log(Level.SEVERE, "wrong invocation method execBeginTime: 0");
            }
            record.execEndTime = time;
            record.execDuration = record.execEndTime - record.execBeginTime;
            record.invocationCount++;
        }
    }

    private static class MethodArgumentRecord {
        private int index;
        private Object value;

        public MethodArgumentRecord(int index, Object value) {
            this.index = index;
            this.value = value;
        }
    }

    private static class InvocationTargetRecord {
        public int line;
        private String calleeSig;
        private String methodName;
        private String className;
        private long invocationCount;
        private long execBeginTime;
        private long execEndTime;
        private long execDuration;
        private int shouldNotDeepin;
        private long offset;

        public InvocationTargetRecord(String owner, String name, String sig) {
            this.calleeSig = sig;
            this.className = owner.replace("/", ".");
            this.execBeginTime = 0L;
            this.methodName = name;
            this.shouldNotDeepin = JvmMonitorUtil.shouldExcludeClass(owner.replace("/", ".")) ? 1 : 0;
        }

        public long getOffset() {
            return this.offset;
        }

        public int getLine() {
            return this.line;
        }

        public void setLine(int line) {
            this.line = line;
        }

        public String getCalleeSig() {
            return this.calleeSig;
        }

        public void setCalleeSig(String calleeSig) {
            this.calleeSig = calleeSig;
        }

        public String getMethodName() {
            return this.methodName;
        }

        public void setMethodName(String methodName) {
            this.methodName = methodName;
        }

        public String getClassName() {
            return this.className;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        public long getInvocationCount() {
            return this.invocationCount;
        }

        public void setInvocationCount(long invocationCount) {
            this.invocationCount = invocationCount;
        }

        public long getExecBeginTime() {
            return this.execBeginTime;
        }

        public void setExecBeginTime(long execBeginTime) {
            this.execBeginTime = execBeginTime;
        }

        public long getExecEndTime() {
            return this.execEndTime;
        }

        public void setExecEndTime(long execEndTime) {
            this.execEndTime = execEndTime;
        }

        public long getExecDuration() {
            return this.execDuration;
        }

        public void setExecDuration(long execDuration) {
            this.execDuration = execDuration;
        }

        public int getShouldNotDeepin() {
            return this.shouldNotDeepin;
        }

        public void setShouldNotDeepin(int shouldNotDeepin) {
            this.shouldNotDeepin = shouldNotDeepin;
        }
    }
}

