/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.asm.api.httpcontextmanagerapi;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.io.ByteArrayOutputStream;
import java.io.CharArrayWriter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.nio.CharBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;

public class HttpComponentResult {
    private static final PatchLogger logger = PatchLogger.getLogger(HttpComponentResult.class.getName());
    private static final String IS_FORM_FIELD_METHOD = "isFormField";
    private static final String GET_FORM_VALE_METHOD = "getString";
    private boolean processingMultipart = false;
    private boolean memoryLimitLogged = false;
    private static final int MAX_BODY_CACHE_SIZE = 524288;
    private static final int CHAR_CHUNK_SIZE = 2048;
    private static final int MAX_CHAR_CHUNKS = 256;
    public int lastEndScanPosition = 0;
    private byte[] compressedCharCache;
    public List<char[]> charChunks;
    public int totalChars;
    public static final int MAX_TOTAL_BUFFER_SIZE = 0x100000;
    private static final int MAX_PARAM_COUNT = 10000;
    public transient byte[] compressedCache;
    public transient List<byte[]> chunkedCache;
    public int totalBytesRead;
    private int byteCacheSize = 0;
    private int charCacheSize = 0;
    private int paramCount = 0;
    private boolean bodyReadComplete = false;
    private int readMark = 0;
    private int formParamSize = 0;
    private int pathParamLength = 0;
    private int headerParamLength = 0;
    private int cookieParamLength = 0;
    private int matrixParamLength = 0;
    private boolean isPathParamDone = false;
    private boolean isHeaderParamDone = false;
    private boolean isCookieParamDone = false;
    private boolean isNormalParamDone = false;
    private boolean isBodyParamDone = false;
    private boolean isKnownBody = false;
    private boolean paramRead = false;
    private List<String> formParams;
    private List<String> headerParams;
    private List<String> cookieParams;
    private List<String> matrixParams;
    private List<String> pathParams;
    private List<String> normalParams;
    private List<String> completeParams;
    private String method;
    private String requestUrl;
    private String requestUri;
    private String servletPath;
    private String queryString;
    private Map<String, String[]> parameterMap;
    private Map<String, String> headers;
    private String clientIp;
    private String contentType;
    private int contentLength;
    private String characterEncoding;
    private String completeRequest;
    private Map<String, String> cookies;
    private boolean isChunked;
    private String requestString;
    private Object request;
    private Object responseModel;
    public ByteArrayOutputStream byteCache;
    private CharArrayWriter charCache;
    private String body;
    private String name;
    private String value;
    private int pathIndex;
    private String pathSegment;
    private String uri;
    private boolean isMultiValue;
    private List<String> valueList;
    private Map<String, List<String>> matrixVariableMap;
    private String rawMatrixVariables;
    private final Map<String, String> attributes = new HashMap<String, String>();

    public boolean checkTotalBufferSize(int additionalSize) {
        int totalSize = this.byteCacheSize + this.charCacheSize + additionalSize;
        if (totalSize > 0x100000) {
            logger.log(Level.FINE, "Total buffer size exceeds limit: {0}/{1} (byte cache: {2}, char cache: {3})", new Object[]{totalSize, 0x100000, this.byteCacheSize, this.charCacheSize});
            return false;
        }
        return true;
    }

    public boolean isProcessingMultipart() {
        return this.processingMultipart;
    }

    public byte[] getCompressedCharCache() {
        return this.compressedCharCache;
    }

    public void setCompressedCharCache(byte[] compressedCharCache) {
        this.compressedCharCache = compressedCharCache;
    }

    public void setProcessingMultipart(boolean processingMultipart) {
        this.processingMultipart = processingMultipart;
    }

    public boolean isMemoryLimitLogged() {
        return this.memoryLimitLogged;
    }

    public void setMemoryLimitLogged(boolean memoryLimitLogged) {
        this.memoryLimitLogged = memoryLimitLogged;
    }

    private boolean checkParamCount() {
        if (this.paramCount >= 10000) {
            logger.log(Level.FINE, "Parameter count exceeds limit: {0}/{1}", new Object[]{this.paramCount, 10000});
            return false;
        }
        return true;
    }

    public HttpComponentResult() {
        this.valueList = new ArrayList<String>();
        this.matrixVariableMap = new HashMap<String, List<String>>();
        this.formParams = new ArrayList<String>();
        this.headerParams = new ArrayList<String>();
        this.cookieParams = new ArrayList<String>();
        this.matrixParams = new ArrayList<String>();
        this.pathParams = new ArrayList<String>();
        this.normalParams = new ArrayList<String>();
        this.completeParams = new ArrayList<String>();
        this.headers = new HashMap<String, String>();
        this.cookies = new HashMap<String, String>();
        this.parameterMap = new HashMap<String, String[]>();
    }

    public HttpComponentResult(Object request) {
        this();
        this.request = request;
    }

    public HttpComponentResult(Object request, Object response) {
        this(request);
        this.responseModel = response;
    }

    public void cacheFormParams(List<?> items) {
        if (this.formParams == null) {
            this.formParams = new ArrayList<String>();
        }
        for (Object item : items) {
            try {
                Method method2;
                String v;
                Method method = item.getClass().getMethod(IS_FORM_FIELD_METHOD, new Class[0]);
                boolean notFile = (Boolean)method.invoke(item, new Object[0]);
                if (!notFile || (v = (String)(method2 = item.getClass().getMethod(GET_FORM_VALE_METHOD, new Class[0])).invoke(item, new Object[0])) == null || v.isEmpty()) continue;
                int paramSize = v.length() * 2;
                if (!this.checkTotalBufferSize(paramSize) || !this.checkParamCount()) {
                    return;
                }
                this.formParams.add(v);
                this.formParamSize += paramSize;
                this.charCacheSize += paramSize;
                ++this.paramCount;
                if (this.formParamSize <= 524288) continue;
                logger.log(Level.FINE, "Form data size exceeds limit: {0}/{1}", new Object[]{this.formParamSize, 524288});
                return;
            }
            catch (Throwable t) {
                logger.log(Level.FINE, "Error caching form data: {0}", t.getMessage());
            }
        }
    }

    public void addNormalParam(String param) {
        if (param == null || param.isEmpty()) {
            return;
        }
        if (!this.checkParamCount()) {
            return;
        }
        int paramSize = 24 + param.length() * 2;
        if (!this.checkTotalBufferSize(paramSize)) {
            return;
        }
        if (this.normalParams == null) {
            this.normalParams = new ArrayList<String>();
        }
        this.normalParams.add(param);
        ++this.paramCount;
        this.charCacheSize += paramSize;
    }

    public void addPathParam(String param) {
        if (param == null || param.isEmpty()) {
            return;
        }
        if (!this.checkParamCount()) {
            return;
        }
        int paramSize = 24 + param.length() * 2;
        if (!this.checkTotalBufferSize(paramSize)) {
            return;
        }
        if (this.pathParams == null) {
            this.pathParams = new ArrayList<String>();
        }
        this.pathParams.add(param);
        ++this.paramCount;
        this.charCacheSize += paramSize;
    }

    public void addHeaderParam(String param) {
        if (param == null || param.isEmpty()) {
            return;
        }
        if (!this.checkParamCount()) {
            return;
        }
        int paramSize = 24 + param.length() * 2;
        if (!this.checkTotalBufferSize(paramSize)) {
            return;
        }
        if (this.headerParams == null) {
            this.headerParams = new ArrayList<String>();
        }
        this.headerParams.add(param);
        ++this.paramCount;
        this.charCacheSize += paramSize;
    }

    public void addCookieParam(String param) {
        if (param == null || param.isEmpty()) {
            return;
        }
        if (!this.checkParamCount()) {
            return;
        }
        int paramSize = 24 + param.length() * 2;
        if (!this.checkTotalBufferSize(paramSize)) {
            return;
        }
        if (this.cookieParams == null) {
            this.cookieParams = new ArrayList<String>();
        }
        this.cookieParams.add(param);
        ++this.paramCount;
        this.charCacheSize += paramSize;
    }

    public void addMatrixParam(String param) {
        if (param == null || param.isEmpty()) {
            return;
        }
        if (!this.checkParamCount()) {
            return;
        }
        int paramSize = 24 + param.length() * 2;
        if (!this.checkTotalBufferSize(paramSize)) {
            return;
        }
        if (this.matrixParams == null) {
            this.matrixParams = new ArrayList<String>();
        }
        this.matrixParams.add(param);
        ++this.paramCount;
        this.charCacheSize += paramSize;
    }

    public void addValue(String value) {
        if (value == null || value.isEmpty()) {
            return;
        }
        if (!this.checkParamCount()) {
            return;
        }
        int paramSize = 24 + value.length() * 2;
        if (!this.checkTotalBufferSize(paramSize)) {
            return;
        }
        if (this.valueList == null) {
            this.valueList = new ArrayList<String>();
        }
        this.valueList.add(value);
        this.isMultiValue = this.valueList.size() > 1;
        this.value = value;
        ++this.paramCount;
        this.charCacheSize += paramSize;
    }

    public void addMatrixVariable(String key, String value) {
        if (key == null || value == null) {
            return;
        }
        if (!this.checkParamCount()) {
            return;
        }
        int paramSize = 24 + key.length() * 2 + value.length() * 2;
        if (!this.checkTotalBufferSize(paramSize)) {
            return;
        }
        if (this.matrixVariableMap == null) {
            this.matrixVariableMap = new HashMap<String, List<String>>();
        }
        List values = this.matrixVariableMap.computeIfAbsent(key, k -> new ArrayList());
        values.add(value);
        ++this.paramCount;
        this.charCacheSize += paramSize;
    }

    public void setByteCache(ByteArrayOutputStream byteCache) {
        if (this.byteCache != null) {
            this.byteCacheSize = 0;
        }
        this.byteCache = byteCache;
        if (byteCache != null) {
            this.byteCacheSize = byteCache.size();
        }
    }

    public void setCharCache(CharArrayWriter charCache) {
        if (this.charCache != null) {
            this.charCacheSize = 0;
        }
        this.charCache = charCache;
        if (charCache != null) {
            this.charCacheSize = charCache.size() * 2;
        }
    }

    public void clear() {
        this.byteCacheSize = 0;
        this.charCacheSize = 0;
        this.paramCount = 0;
        this.lastEndScanPosition = 0;
        this.name = null;
        this.value = null;
        this.pathIndex = 0;
        this.pathSegment = null;
        this.uri = null;
        this.isMultiValue = false;
        this.rawMatrixVariables = null;
        if (this.valueList != null) {
            this.valueList.clear();
        }
        if (this.matrixVariableMap != null) {
            this.matrixVariableMap.clear();
        }
        this.attributes.clear();
        this.method = null;
        this.requestUrl = null;
        this.requestUri = null;
        this.servletPath = null;
        this.queryString = null;
        this.clientIp = null;
        this.contentType = null;
        this.contentLength = 0;
        this.characterEncoding = null;
        this.completeRequest = null;
        this.requestString = null;
        this.isChunked = false;
        if (this.parameterMap != null) {
            this.parameterMap.clear();
        }
        if (this.headers != null) {
            this.headers.clear();
        }
        if (this.cookies != null) {
            this.cookies.clear();
        }
        if (this.completeParams != null) {
            this.completeParams.clear();
        }
        this.byteCache = null;
        this.charCache = null;
        this.body = null;
        this.bodyReadComplete = false;
        this.readMark = 0;
        this.formParamSize = 0;
        this.pathParamLength = 0;
        this.headerParamLength = 0;
        this.cookieParamLength = 0;
        this.matrixParamLength = 0;
        if (this.formParams != null) {
            this.formParams.clear();
        }
        if (this.headerParams != null) {
            this.headerParams.clear();
        }
        if (this.cookieParams != null) {
            this.cookieParams.clear();
        }
        if (this.matrixParams != null) {
            this.matrixParams.clear();
        }
        if (this.pathParams != null) {
            this.pathParams.clear();
        }
        if (this.normalParams != null) {
            this.normalParams.clear();
        }
        if (this.valueList != null && this.valueList instanceof ArrayList) {
            ((ArrayList)this.valueList).clear();
            ((ArrayList)this.valueList).trimToSize();
        }
        if (this.byteCache != null) {
            ByteArrayOutputStream old = this.byteCache;
            this.byteCache = new ByteArrayOutputStream(256);
            try {
                old.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        if (this.parameterMap != null && this.parameterMap.size() > 8) {
            this.parameterMap = new HashMap<String, String[]>(4);
        }
        this.isPathParamDone = false;
        this.isHeaderParamDone = false;
        this.isCookieParamDone = false;
        this.isNormalParamDone = false;
        this.isBodyParamDone = false;
        this.isKnownBody = false;
        this.paramRead = false;
        this.request = null;
        this.responseModel = null;
        this.processingMultipart = false;
        this.memoryLimitLogged = false;
        this.compressedCharCache = null;
        this.compressedCache = null;
        if (this.charChunks != null) {
            this.charChunks.clear();
            this.charChunks = null;
        }
        this.totalChars = 0;
        if (this.chunkedCache != null) {
            this.chunkedCache.clear();
            this.chunkedCache = null;
        }
        this.totalBytesRead = 0;
        this.isKnownBody = false;
        if (this.charChunks != null) {
            this.charChunks.clear();
            this.charChunks = null;
        }
        if (this.chunkedCache != null) {
            this.chunkedCache.clear();
            this.chunkedCache = null;
        }
        this.compressedCharCache = null;
        this.compressedCache = null;
        this.totalBytesRead = 0;
        this.totalChars = 0;
        this.byteCacheSize = 0;
        this.charCacheSize = 0;
        this.paramCount = 0;
        this.formParamSize = 0;
        if (this.valueList != null && this.valueList instanceof ArrayList) {
            ((ArrayList)this.valueList).clear();
            ((ArrayList)this.valueList).trimToSize();
        }
        if (this.byteCache != null) {
            this.byteCache.reset();
            if (this.byteCache.size() > 4096) {
                this.byteCache = new ByteArrayOutputStream(256);
            }
        }
        if (this.parameterMap != null && this.parameterMap.size() > 8) {
            this.parameterMap = new HashMap<String, String[]>(4);
        }
        if (this.matrixVariableMap != null && this.matrixVariableMap.size() > 8) {
            this.matrixVariableMap = new HashMap<String, List<String>>(4);
        }
        this.body = null;
        this.name = null;
        this.value = null;
        this.pathSegment = null;
        this.uri = null;
        this.rawMatrixVariables = null;
        this.attributes.clear();
    }

    public int getTotalEstimatedSize() {
        return this.byteCacheSize + this.charCacheSize;
    }

    public int getParamCount() {
        return this.paramCount;
    }

    public String getMemoryUsageStatus() {
        double bufferUsagePercent = 100.0 * (double)this.getTotalEstimatedSize() / 1048576.0;
        double paramUsagePercent = 100.0 * (double)this.paramCount / 10000.0;
        return String.format(Locale.ROOT, "\u5185\u5b58\u4f7f\u7528: \u7f13\u51b2\u533a %.2f%% (%d/%d \u5b57\u8282), \u53c2\u6570 %.2f%% (%d/%d)", bufferUsagePercent, this.getTotalEstimatedSize(), 0x100000, paramUsagePercent, this.paramCount, 10000);
    }

    public HttpComponentResult shallowClone() throws IOException {
        HttpComponentResult clone = new HttpComponentResult();
        clone.method = this.method;
        clone.requestUrl = this.requestUrl;
        clone.requestUri = this.requestUri;
        clone.servletPath = this.servletPath;
        clone.queryString = this.queryString;
        clone.clientIp = this.clientIp;
        clone.contentType = this.contentType;
        clone.contentLength = this.contentLength;
        clone.characterEncoding = this.characterEncoding;
        clone.completeRequest = this.completeRequest;
        clone.requestString = this.requestString;
        clone.isChunked = this.isChunked;
        clone.lastEndScanPosition = this.lastEndScanPosition;
        clone.bodyReadComplete = this.bodyReadComplete;
        clone.readMark = this.readMark;
        clone.formParamSize = this.formParamSize;
        clone.pathParamLength = this.pathParamLength;
        clone.headerParamLength = this.headerParamLength;
        clone.cookieParamLength = this.cookieParamLength;
        clone.matrixParamLength = this.matrixParamLength;
        clone.isPathParamDone = this.isPathParamDone;
        clone.isHeaderParamDone = this.isHeaderParamDone;
        clone.isCookieParamDone = this.isCookieParamDone;
        clone.isNormalParamDone = this.isNormalParamDone;
        clone.isBodyParamDone = this.isBodyParamDone;
        clone.isKnownBody = this.isKnownBody;
        clone.paramRead = this.paramRead;
        clone.name = this.name;
        clone.value = this.value;
        clone.pathIndex = this.pathIndex;
        clone.pathSegment = this.pathSegment;
        clone.uri = this.uri;
        clone.isMultiValue = this.isMultiValue;
        clone.rawMatrixVariables = this.rawMatrixVariables;
        clone.byteCacheSize = this.byteCacheSize;
        clone.charCacheSize = this.charCacheSize;
        clone.paramCount = this.paramCount;
        clone.body = this.body;
        if (this.byteCache != null) {
            clone.byteCache = new ByteArrayOutputStream();
            try {
                clone.byteCache.write(this.byteCache.toByteArray());
            }
            catch (Exception e) {
                logger.log(Level.FINE, "Error copying byte cache: {0}", e.getMessage());
            }
        }
        if (this.charCache != null) {
            clone.charCache = new CharArrayWriter();
            clone.charCache.write(this.charCache.toCharArray());
        }
        if (this.formParams != null) {
            clone.formParams = new ArrayList<String>(this.formParams);
        }
        if (this.headerParams != null) {
            clone.headerParams = new ArrayList<String>(this.headerParams);
        }
        if (this.cookieParams != null) {
            clone.cookieParams = new ArrayList<String>(this.cookieParams);
        }
        if (this.matrixParams != null) {
            clone.matrixParams = new ArrayList<String>(this.matrixParams);
        }
        if (this.pathParams != null) {
            clone.pathParams = new ArrayList<String>(this.pathParams);
        }
        if (this.normalParams != null) {
            clone.normalParams = new ArrayList<String>(this.normalParams);
        }
        if (this.completeParams != null) {
            clone.completeParams = new ArrayList<String>(this.completeParams);
        }
        if (this.valueList != null) {
            clone.valueList = new ArrayList<String>(this.valueList);
        }
        if (this.parameterMap != null) {
            clone.parameterMap = new HashMap<String, String[]>(this.parameterMap);
        }
        if (this.headers != null) {
            clone.headers = new HashMap<String, String>(this.headers);
        }
        if (this.cookies != null) {
            clone.cookies = new HashMap<String, String>(this.cookies);
        }
        if (this.matrixVariableMap != null) {
            clone.matrixVariableMap = new HashMap<String, List<String>>();
            for (Map.Entry<String, List<String>> entry : this.matrixVariableMap.entrySet()) {
                clone.matrixVariableMap.put(entry.getKey(), new ArrayList(entry.getValue()));
            }
        }
        clone.attributes.putAll(this.attributes);
        return clone;
    }

    public boolean hasAttribute(String key) {
        return this.attributes.containsKey(key);
    }

    public List<String> getCompleteParams() {
        return this.completeParams;
    }

    public List<String> getCompleteParams(boolean needPathParam, boolean needHeaderParam, boolean needCookieParam, boolean needMatrixParam) {
        if (this.completeParams == null) {
            this.completeParams = new ArrayList<String>();
        } else {
            this.completeParams.clear();
        }
        if (this.normalParams != null && !this.normalParams.isEmpty()) {
            this.completeParams.addAll(this.normalParams);
        }
        if (needPathParam && this.pathParams != null && !this.pathParams.isEmpty()) {
            this.completeParams.addAll(this.pathParams);
        }
        if (needHeaderParam && this.headerParams != null && !this.headerParams.isEmpty()) {
            this.completeParams.addAll(this.headerParams);
        }
        if (needCookieParam && this.cookieParams != null && !this.cookieParams.isEmpty()) {
            this.completeParams.addAll(this.cookieParams);
        }
        if (needMatrixParam && this.matrixParams != null && !this.matrixParams.isEmpty()) {
            this.completeParams.addAll(this.matrixParams);
        }
        return this.completeParams;
    }

    public List<String> getFormParams() {
        return this.formParams;
    }

    public List<String> getMatrixParams() {
        return this.matrixParams;
    }

    public void setNormalParams(List<String> normalParams) {
        this.normalParams = normalParams;
    }

    public String getMethod() {
        return this.method;
    }

    public void setMethod(String method) {
        this.method = method;
    }

    public String getRequestUrl() {
        return this.requestUrl;
    }

    public void setRequestUrl(String requestUrl) {
        this.requestUrl = requestUrl;
    }

    public String getRequestUri() {
        return this.requestUri;
    }

    public void setRequestUri(String requestUri) {
        this.requestUri = requestUri;
    }

    public String getServletPath() {
        return this.servletPath;
    }

    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String queryString) {
        this.queryString = queryString;
    }

    public String getClientIp() {
        return this.clientIp;
    }

    public void setClientIp(String clientIp) {
        this.clientIp = clientIp;
    }

    public String getContentType() {
        return this.contentType;
    }

    public void setContentType(String contentType) {
        this.contentType = contentType;
    }

    public int getContentLength() {
        return this.contentLength;
    }

    public void setContentLength(int contentLength) {
        this.contentLength = contentLength;
    }

    public String getCharacterEncoding() {
        return this.characterEncoding;
    }

    public void setCharacterEncoding(String characterEncoding) {
        this.characterEncoding = characterEncoding;
    }

    public String getCompleteRequest() {
        return this.completeRequest;
    }

    public void setCompleteRequest(String completeRequest) {
        this.completeRequest = completeRequest;
    }

    public Map<String, String> getCookies() {
        return this.cookies;
    }

    public void setCookies(Map<String, String> cookies) {
        this.cookies = cookies;
    }

    public boolean isChunked() {
        return this.isChunked;
    }

    public void setChunked(boolean chunked) {
        this.isChunked = chunked;
    }

    public void setBody(String body) {
        int oldSize = this.body != null ? this.body.length() * 2 : 0;
        int newSize = body != null ? body.length() * 2 : 0;
        this.charCacheSize = this.charCacheSize - oldSize + newSize;
        this.body = body;
    }

    public boolean isBodyReadComplete() {
        return this.bodyReadComplete;
    }

    public void setBodyReadComplete(boolean bodyReadComplete) {
        this.bodyReadComplete = bodyReadComplete;
    }

    public void setPathParamLength(int pathParamLength) {
        this.pathParamLength = pathParamLength;
    }

    public void setHeaderParamLength(int headerParamLength) {
        this.headerParamLength = headerParamLength;
    }

    public void setCookieParamLength(int cookieParamLength) {
        this.cookieParamLength = cookieParamLength;
    }

    public void setMatrixParamLength(int matrixParamLength) {
        this.matrixParamLength = matrixParamLength;
    }

    public boolean isPathParamDone() {
        return this.isPathParamDone;
    }

    public boolean isHeaderParamDone() {
        return this.isHeaderParamDone;
    }

    public boolean isCookieParamDone() {
        return this.isCookieParamDone;
    }

    public boolean isNormalParamDone() {
        return this.isNormalParamDone;
    }

    public boolean isBodyParamDone() {
        return this.isBodyParamDone;
    }

    public ByteArrayOutputStream getByteCache() {
        return this.byteCache;
    }

    public CharArrayWriter getCharCache() {
        return this.charCache;
    }

    public Object getRequest() {
        return this.request;
    }

    public void setRequest(Object request) {
        this.request = request;
    }

    public Object getResponseModel() {
        return this.responseModel;
    }

    public Map<String, String[]> getParameterMap() {
        return this.parameterMap;
    }

    public void setParameterMap(Map<String, String[]> parameterMap) {
        this.parameterMap = parameterMap;
    }

    public Map<String, String> getHeaders() {
        return this.headers;
    }

    public void setHeaders(Map<String, String> headers) {
        this.headers = headers;
    }

    public boolean isParamRead() {
        return this.paramRead;
    }

    public void setParamRead(boolean paramRead) {
        this.paramRead = paramRead;
    }

    public String getName() {
        return this.name;
    }

    public void setHttpName(String name) {
        this.name = name;
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setPathSegment(String pathSegment) {
        this.pathSegment = pathSegment;
    }

    public String getUri() {
        return this.uri;
    }

    public void setUri(String uri) {
        this.uri = uri;
    }

    public void setRawMatrixVariables(String rawMatrixVariables) {
        this.rawMatrixVariables = rawMatrixVariables;
    }

    public String getAttribute(String key) {
        return this.attributes.get(key);
    }

    public void setAttribute(String key, String value) {
        this.attributes.put(key, value);
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void pathParamDone() {
        this.isPathParamDone = true;
    }

    public void headerParamDone() {
        this.isHeaderParamDone = true;
    }

    public void cookieParamDone() {
        this.isCookieParamDone = true;
    }

    public void normalParamDone() {
        this.isNormalParamDone = true;
    }

    public void bodyParamDone(boolean isKnownBody) {
        this.isBodyParamDone = true;
        this.isKnownBody = isKnownBody;
    }

    public void increaseMark() {
        ++this.readMark;
    }

    public void decreaseMark() {
        --this.readMark;
    }

    public boolean hasMark() {
        return this.readMark != 0;
    }

    public boolean isFormParamsEmpty() {
        return this.formParams == null || this.formParams.isEmpty();
    }

    public void clearFormDataCache() {
        this.formParams = null;
    }

    public String getBody() {
        return this.body;
    }

    private void addToCharCache(char c) {
        char[] currentChunk;
        if (this.charChunks == null) {
            this.charChunks = new ArrayList<char[]>();
        }
        if (this.charChunks.size() >= 256) {
            return;
        }
        int chunkIndex = this.charChunks.size() - 1;
        if (chunkIndex < 0 || (currentChunk = this.charChunks.get(chunkIndex)).length == 2048) {
            currentChunk = new char[2048];
            this.charChunks.add(currentChunk);
            ++chunkIndex;
        }
        int pos = this.totalChars % 2048;
        currentChunk[pos] = c;
        ++this.totalChars;
    }

    private void addToCharCache(char[] data, int off, int len) {
        for (int i = 0; i < len; ++i) {
            this.addToCharCache(data[off + i]);
        }
    }

    public void appendCharData(int data) {
        if (data == -1) {
            this.bodyReadComplete = true;
            return;
        }
        if (data < 0) {
            return;
        }
        if (!this.checkTotalBufferSize(2)) {
            return;
        }
        this.addToCharCache((char)data);
    }

    public void appendCharData(char[] data, int off, int len) {
        if (len == -1) {
            this.bodyReadComplete = true;
            return;
        }
        if (len <= 0) {
            return;
        }
        int charSize = len * 2;
        if (!this.checkTotalBufferSize(charSize)) {
            return;
        }
        this.addToCharCache(data, off, len);
    }

    public void appendCharData(CharBuffer data, int len) {
        if (len == -1) {
            this.bodyReadComplete = true;
            return;
        }
        if (len <= 0) {
            return;
        }
        int charSize = len * 2;
        if (!this.checkTotalBufferSize(charSize)) {
            return;
        }
        for (int i = 0; i < len; ++i) {
            this.addToCharCache(data.get());
        }
    }

    public void appendLine(String line) {
        if (line == null) {
            this.bodyReadComplete = true;
            return;
        }
        int charSize = line.length() * 2;
        if (this.charChunks != null && !this.charChunks.isEmpty()) {
            charSize += 2;
        }
        if (!this.checkTotalBufferSize(charSize)) {
            return;
        }
        if (this.charChunks != null && !this.charChunks.isEmpty()) {
            this.addToCharCache('\n');
        }
        this.addToCharCache(line.toCharArray(), 0, line.length());
    }

    public String getCharCacheContent() {
        if (this.charChunks == null || this.charChunks.isEmpty()) {
            return null;
        }
        StringBuilder sb = new StringBuilder(this.totalChars);
        for (char[] chunk : this.charChunks) {
            int len = Math.min(chunk.length, 2048);
            sb.append(chunk, 0, len);
        }
        return sb.toString();
    }

    public void clearBodyCache() {
        this.byteCache = null;
        this.charCache = null;
        this.byteCacheSize = 0;
        this.charCacheSize = 0;
        this.body = null;
    }

    public byte[] getCompressedCache() {
        return this.compressedCache;
    }

    public void setCompressedCache(Object o) {
        this.compressedCache = (byte[])o;
    }

    public void setCharChunks(Object chunks) {
        if (chunks instanceof List) {
            List list = (List)chunks;
            if (!list.isEmpty() && list.get(0) instanceof char[]) {
                this.charChunks = (List)chunks;
            } else {
                this.charChunks = new ArrayList<char[]>();
                logger.log(Level.FINE, "Invalid char chunks type: {0}", chunks.getClass().getName());
            }
        } else {
            this.charChunks = new ArrayList<char[]>();
            logger.log(Level.FINE, "Invalid char chunks object: {0}", chunks != null ? chunks.getClass().getName() : "null");
        }
    }

    public List<char[]> getCharChunks() {
        if (this.charChunks == null) {
            this.charChunks = new ArrayList<char[]>();
        }
        return this.charChunks;
    }

    public void setTotalChars(int i) {
        this.totalChars = i;
    }
}

