/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.api;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.GlobalProfilerConfigProvider;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.ProfilerConfigProvider;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.Sampling;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util.TencentCommonConfigUtil;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Tracer;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.ContextKey;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.api.ServerPeerServiceAttributeExtractor;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.api.SkywalkingContextCarrierAttributeExtractor;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.api.TencentInstrumentationTranslator;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.api.TencentInstrumenterHelper;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.api.TencentTracer;
import java.util.concurrent.ThreadLocalRandom;

public final class TencentTracerHelper {
    static final ContextKey<Boolean> KEY = ContextKey.named("tencent-trace-is-store");

    private TencentTracerHelper() {
    }

    public static boolean shouldInterrupt(Context parentContext, String instrumentationName) {
        ProfilerConfigProvider profilerConfigProvider = GlobalProfilerConfigProvider.get();
        return !profilerConfigProvider.isAgentEnable() || Double.compare(profilerConfigProvider.getSampling().getSampleRate(), 0.0) == 0 || profilerConfigProvider.isDisabledPlugin(TencentInstrumentationTranslator.getBriefInstrumentationName(instrumentationName));
    }

    public static TencentInstrumenterHelper decideTheTracerAndGetHelper(Tracer normalTracer, Context parentContext, String spanName) {
        Boolean isStore = parentContext.get(KEY);
        if (isStore != null) {
            if (isStore.booleanValue()) {
                return TencentInstrumenterHelper.build(normalTracer.spanBuilder(spanName), parentContext);
            }
            return TencentInstrumenterHelper.build(TencentTracer.getInstance().spanBuilder(spanName), parentContext);
        }
        ProfilerConfigProvider profilerConfigProvider = GlobalProfilerConfigProvider.get();
        Sampling sampling = profilerConfigProvider.getSampling();
        double sampleRate = sampling.getSampleRate();
        if (sampleRate == 0.0) {
            return TencentInstrumenterHelper.build(TencentTracer.getInstance().spanBuilder(spanName), parentContext, false);
        }
        if (sampleRate == 1.0) {
            return TencentInstrumenterHelper.build(normalTracer.spanBuilder(spanName), parentContext, true);
        }
        SpanContext parent = Span.fromContext(parentContext).getSpanContext();
        Tracer defaultTracer = normalTracer;
        boolean storeTrace = true;
        if (parent.isValid()) {
            if (sampling.shouldSample(parent.getTraceId())) {
                defaultTracer = TencentTracer.getInstance();
                storeTrace = false;
            }
        } else if (ThreadLocalRandom.current().nextDouble(1.0) >= sampleRate) {
            defaultTracer = TencentTracer.getInstance();
            storeTrace = false;
        }
        return TencentInstrumenterHelper.build(defaultTracer.spanBuilder(spanName), parentContext, storeTrace);
    }

    public static void beforeStart(Context parentContext, AttributesBuilder startAttributes, String instrumentationName, SpanKind spanKind, String operationName) {
        if (TencentCommonConfigUtil.isTestMode()) {
            return;
        }
        startAttributes.put(SemanticAttributes.COMPONENT, instrumentationName);
        startAttributes.put(SemanticAttributes.SPAN_KIND, spanKind.toString());
        startAttributes.put(SemanticAttributes.OPERATION, operationName);
        ServerPeerServiceAttributeExtractor.richPeerServiceAttribute(parentContext, startAttributes, spanKind);
        SkywalkingContextCarrierAttributeExtractor.richSkywalkingTraceId(parentContext, startAttributes);
    }
}

