/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.tencent.javaagent.shaded.instrumentation.api;

import io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.semconv.SemanticAttributes;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.common.AttributesBuilder;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.Span;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanContext;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.SpanKind;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.api.trace.TraceState;
import io.opentelemetry.javaagent.shaded.io.opentelemetry.context.Context;
import io.opentelemetry.tencent.javaagent.shaded.instrumentation.api.BaggageUtil;

public final class ServerPeerServiceAttributeExtractor {
    private static final String contextServiceName = "tencent-service-name";

    public static void richPeerServiceAttribute(Context parentContext, AttributesBuilder attributes, SpanKind spanKind) {
        if (spanKind.equals((Object)SpanKind.SERVER)) {
            String peerServiceName = ServerPeerServiceAttributeExtractor.getPeerServiceNameFromTraceState(parentContext);
            if (!peerServiceName.isEmpty()) {
                attributes.put(SemanticAttributes.PEER_SERVICE, peerServiceName);
                return;
            }
            peerServiceName = BaggageUtil.getValueFromBaggage(parentContext, contextServiceName);
            if (!peerServiceName.isEmpty()) {
                attributes.put(SemanticAttributes.PEER_SERVICE, peerServiceName);
            }
        }
    }

    private static String getPeerServiceNameFromTraceState(Context parentContext) {
        String serviceName;
        TraceState traceState;
        SpanContext parentSpanContext = Span.fromContext(parentContext).getSpanContext();
        if (parentSpanContext != null && (traceState = parentSpanContext.getTraceState()) != null && !traceState.isEmpty() && (serviceName = traceState.get(contextServiceName)) != null && !serviceName.isEmpty()) {
            return serviceName;
        }
        return "";
    }

    private ServerPeerServiceAttributeExtractor() {
    }
}

