/*
 * Decompiled with CFR 0.152.
 */
package io.opentelemetry.extension.tencent.javaagent.shaded.io.opentelemetry.api.util;

import io.opentelemetry.javaagent.bootstrap.PatchLogger;
import java.nio.ByteBuffer;
import java.security.MessageDigest;
import java.text.Normalizer;
import java.util.Locale;
import java.util.logging.Level;
import java.util.regex.Pattern;

public final class ChineseHashUtil {
    private static final PatchLogger logger = PatchLogger.getLogger(ChineseHashUtil.class.getName());
    private static final Pattern SERVICE_NAME_INVALID_PATTERN = Pattern.compile("[^a-zA-Z0-9.:\\-_]");
    private static final String SERVICE_NAME_PREFIX = "nacos_svc_";

    private ChineseHashUtil() {
    }

    public static boolean isValidServiceName(String text) {
        return SERVICE_NAME_INVALID_PATTERN.matcher(text).find();
    }

    public static String getNameHexStr(String origin) {
        byte[] chinese = null;
        try {
            chinese = ChineseHashUtil.hashChinese(origin);
        }
        catch (Exception e) {
            logger.log(Level.SEVERE, "failed to transfer name to hex string", e);
        }
        if (chinese == null || chinese.length == 0) {
            return "";
        }
        return SERVICE_NAME_PREFIX + ChineseHashUtil.bytesToHex(chinese);
    }

    private static String bytesToHex(byte[] bytes) {
        StringBuilder sb = new StringBuilder();
        for (byte b : bytes) {
            sb.append(String.format(Locale.getDefault(), "%02x", b));
        }
        return sb.toString();
    }

    private static byte[] hashChinese(String text) throws Exception {
        String norm = Normalizer.normalize(text, Normalizer.Form.NFC);
        int[] codePoints = norm.codePoints().toArray();
        ByteBuffer buf = ByteBuffer.allocate(codePoints.length * 4);
        for (int cp : codePoints) {
            buf.putInt(cp);
        }
        byte[] data = buf.array();
        MessageDigest md = MessageDigest.getInstance("SHA-256");
        return md.digest(data);
    }
}

